/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import java.io.IOException;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.apache.sling.testing.mock.osgi.MapUtil;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.apache.sling.testing.mock.osgi.OsgiMetadataUtilTest;
import org.apache.sling.testing.mock.osgi.junit.OsgiContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class MockConfigurationAdminTest {
    private static final String[] TEST_ADAPTABLES = new String[]{"adaptable1", "adaptable2"};
    @Rule
    public OsgiContext context = new OsgiContext();
    private ConfigurationAdmin underTest;

    @Before
    public void setUp() {
        this.underTest = (ConfigurationAdmin)this.context.getService(ConfigurationAdmin.class);
    }

    @Test
    public void testGetConfigurationString() throws IOException {
        MockOsgi.setConfigForPid((BundleContext)this.context.bundleContext(), (String)"org.apache.sling.testing.mock.osgi.OsgiMetadataUtilTest$ServiceWithMetadata", (Object[])new Object[]{"service.ranking", 3000, "adaptables", TEST_ADAPTABLES, "prop2", 2});
        this.context.registerInjectActivateService(new OsgiMetadataUtilTest.ServiceWithMetadata(), Map.of("service.ranking", 4000, "prop1", 1));
        ServiceReference reference = this.context.bundleContext().getServiceReference(Comparable.class.getName());
        Assert.assertEquals((Object)4000, (Object)reference.getProperty("service.ranking"));
        Assert.assertEquals((Object)1, (Object)reference.getProperty("prop1"));
        Assert.assertArrayEquals((Object[])TEST_ADAPTABLES, (Object[])((String[])reference.getProperty("adaptables")));
        Assert.assertEquals((Object)2, (Object)reference.getProperty("prop2"));
        Assert.assertEquals((Object)"The Apache Software Foundation", (Object)reference.getProperty("service.vendor"));
        Assert.assertEquals((Object)"org.apache.sling.testing.mock.osgi.OsgiMetadataUtilTest$ServiceWithMetadata", (Object)reference.getProperty("service.pid"));
    }

    @Test
    public void testConfigurationPID() throws IOException {
        MockOsgi.setConfigForPid((BundleContext)this.context.bundleContext(), (String)ServiceWithConfigurationPID.class.getSimpleName(), (Object[])new Object[]{"prop1", 1});
        this.context.registerInjectActivateService(new ServiceWithConfigurationPID(), Map.of("prop2", 2));
        ServiceReference reference = this.context.bundleContext().getServiceReference(Comparable.class.getName());
        Assert.assertEquals((Object)1, (Object)reference.getProperty("prop1"));
        Assert.assertEquals((Object)2, (Object)reference.getProperty("prop2"));
    }

    @Test
    public void testMultipleConfigurationPID() throws IOException {
        MockOsgi.setConfigForPid((BundleContext)this.context.bundleContext(), (String)"Configuration1", (Object[])new Object[]{"prop1", 1});
        MockOsgi.setConfigForPid((BundleContext)this.context.bundleContext(), (String)"Configuration2", (Object[])new Object[]{"prop1", 2});
        this.context.registerInjectActivateService(new ServiceWithMultipleConfigurationPID(), Map.of("prop2", 2));
        ServiceReference reference = this.context.bundleContext().getServiceReference(Comparable.class.getName());
        Assert.assertEquals((Object)2, (Object)reference.getProperty("prop1"));
        Assert.assertEquals((Object)2, (Object)reference.getProperty("prop2"));
    }

    @Test
    public void testFilteringConfigurations() throws IOException, InvalidSyntaxException {
        MockOsgi.setConfigForPid((BundleContext)this.context.bundleContext(), (String)"Configuration1", (Object[])new Object[]{"prop1", 1, "prop2", "B"});
        MockOsgi.setConfigForPid((BundleContext)this.context.bundleContext(), (String)"Configuration2", (Object[])new Object[]{"prop1", 2, "prop2", "A"});
        MockOsgi.setConfigForPid((BundleContext)this.context.bundleContext(), (String)"Configuration3", (Object[])new Object[]{"prop1", 3, "prop2", "A"});
        Configuration[] allConfigurations = this.underTest.listConfigurations("(prop1=*)");
        Assert.assertEquals((long)3L, (long)allConfigurations.length);
        Configuration[] prop2AConfigurations = this.underTest.listConfigurations("(prop2=A)");
        Assert.assertEquals((long)2L, (long)prop2AConfigurations.length);
        Configuration[] searchForAllConfigurations = this.underTest.listConfigurations(null);
        Assert.assertTrue((searchForAllConfigurations.length >= 3 ? 1 : 0) != 0);
        Configuration[] noConfigurations = this.underTest.listConfigurations("(nonexistingprop=nonexistingvalue)");
        Assert.assertNull((Object)noConfigurations);
    }

    @Test
    public void testGetConfigurationViaConfigAdmin_NonExisting() throws IOException {
        Configuration config = this.underTest.getConfiguration("Configuration1");
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((Object)"Configuration1", (Object)config.getPid());
        config = this.underTest.getConfiguration("Configuration1", "location1");
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((Object)"Configuration1", (Object)config.getPid());
    }

    @Test
    public void testGetConfigurationViaConfigAdmin_Existing() throws IOException {
        MockOsgi.setConfigForPid((BundleContext)this.context.bundleContext(), (String)"Configuration1", (Object[])new Object[]{"prop1", 1});
        Configuration config = this.underTest.getConfiguration("Configuration1");
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((Object)"Configuration1", (Object)config.getPid());
        Assert.assertEquals((Object)1, config.getProperties().get("prop1"));
        config = this.underTest.getConfiguration("Configuration1", "location1");
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((Object)"Configuration1", (Object)config.getPid());
        Assert.assertEquals((Object)1, config.getProperties().get("prop1"));
    }

    @Test
    public void testGetUpdateDeleteGetConfiguration() throws IOException {
        Configuration configurationNew = this.underTest.getConfiguration("new-pid");
        Assert.assertNull((Object)configurationNew.getProperties());
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("key", "value");
        configurationNew.update(properties);
        Configuration configurationExisting = this.underTest.getConfiguration("new-pid");
        Assert.assertEquals((Object)"value", configurationNew.getProperties().get("key"));
        Assert.assertNotNull(configurationExisting.getProperties().get("service.pid"));
        Assert.assertNull(configurationExisting.getProperties().get("service.factoryPid"));
        configurationExisting.delete();
        Configuration configurationDeleted = this.underTest.getConfiguration("new-pid");
        Assert.assertNull((Object)configurationDeleted.getProperties());
    }

    @Test
    public void testUpdateIfDifferent() throws IOException {
        Configuration configurationNew = this.underTest.getConfiguration("new-pid");
        Assert.assertNull((Object)configurationNew.getProperties());
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("key", "value");
        ((Dictionary)properties).put("keyArray", new String[]{"A", "B"});
        ((Dictionary)properties).put("keyCollection", Arrays.asList("X", "Y"));
        configurationNew.update(properties);
        Hashtable<String, Object> propertiesNew = new Hashtable<String, Object>(MapUtil.toMap(properties));
        Assert.assertFalse((boolean)configurationNew.updateIfDifferent(propertiesNew));
        ((Dictionary)propertiesNew).put("keyArray", new String[]{"A", "B"});
        ((Dictionary)propertiesNew).put("keyCollection", Arrays.asList("X", "Y"));
        Assert.assertFalse((boolean)configurationNew.updateIfDifferent(propertiesNew));
        ((Dictionary)propertiesNew).put("keyArray", new String[]{"A", "B", "C"});
        Assert.assertTrue((boolean)configurationNew.updateIfDifferent(propertiesNew));
        ((Dictionary)propertiesNew).put("keyCollection", Arrays.asList("X", "Y", "Z"));
        Assert.assertTrue((boolean)configurationNew.updateIfDifferent(propertiesNew));
    }

    @Test
    public void testNoArgUpdateAfterGetFactoryConfiguration() throws IOException {
        Configuration configurationNew = this.underTest.getFactoryConfiguration("my.factory1", "name1");
        Assert.assertNull((Object)configurationNew.getProperties());
        configurationNew.update();
        Configuration configurationExisting = this.underTest.getFactoryConfiguration("my.factory1", "name1");
        Assert.assertNotNull(configurationExisting.getProperties().get("service.pid"));
        Assert.assertNotNull(configurationExisting.getProperties().get("service.factoryPid"));
    }

    @Test
    public void testGetUpdateDeleteGetFactoryConfiguration() throws IOException {
        Configuration configurationNew = this.underTest.getFactoryConfiguration("my.factory1", "name1");
        Assert.assertNull((Object)configurationNew.getProperties());
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("key", "value");
        configurationNew.update(properties);
        Configuration configurationExisting = this.underTest.getFactoryConfiguration("my.factory1", "name1");
        Assert.assertEquals((Object)"value", configurationNew.getProperties().get("key"));
        Assert.assertNotNull(configurationExisting.getProperties().get("service.pid"));
        Assert.assertNotNull(configurationExisting.getProperties().get("service.factoryPid"));
        configurationExisting.delete();
        Configuration configurationDeleted = this.underTest.getFactoryConfiguration("my.factory1", "name1");
        Assert.assertNull((Object)configurationDeleted.getProperties());
    }

    @Test
    public void testGetFactoryConfigurationViaConfigAdmin_NonExisting() throws IOException {
        Configuration config = this.underTest.getFactoryConfiguration("my.factory1", "name1");
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((Object)"my.factory1~name1", (Object)config.getPid());
        Assert.assertEquals((Object)"my.factory1", (Object)config.getFactoryPid());
        config = this.underTest.getFactoryConfiguration("my.factory2", "name2", "location1");
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((Object)"my.factory2~name2", (Object)config.getPid());
        Assert.assertEquals((Object)"my.factory2", (Object)config.getFactoryPid());
    }

    @Test
    public void testGetFactoryConfigurationViaConfigAdmin_Existing() throws IOException {
        MockOsgi.setFactoryConfigForPid((BundleContext)this.context.bundleContext(), (String)"my.factory3", (String)"name3", (Object[])new Object[]{"prop1", 1});
        Configuration config = this.underTest.getFactoryConfiguration("my.factory3", "name3");
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((Object)"my.factory3~name3", (Object)config.getPid());
        Assert.assertEquals((Object)"my.factory3", (Object)config.getFactoryPid());
        Assert.assertEquals((Object)1, config.getProperties().get("prop1"));
        MockOsgi.setFactoryConfigForPid((BundleContext)this.context.bundleContext(), (String)"my.factory4", (String)"name4", Map.of("prop1", 2));
        config = this.underTest.getFactoryConfiguration("my.factory4", "name4", "location1");
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((Object)"my.factory4~name4", (Object)config.getPid());
        Assert.assertEquals((Object)"my.factory4", (Object)config.getFactoryPid());
        Assert.assertEquals((Object)2, config.getProperties().get("prop1"));
    }

    static class ServiceWithConfigurationPID {
        ServiceWithConfigurationPID() {
        }
    }

    static class ServiceWithMultipleConfigurationPID {
        ServiceWithMultipleConfigurationPID() {
        }
    }
}

