/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.settings.impl;

import java.io.PrintStream;
import java.util.Set;
import org.apache.felix.shell.Command;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.propertytypes.ServiceDescription;

@Component
@ServiceDescription(value="Apache Sling Sling Run Mode Shell Command")
public class RunModeCommand
implements Command {
    private static final String CMD_NAME = "runmodes";
    private final Set<String> modes;

    @Activate
    public RunModeCommand(BundleContext btx, @Reference SlingSettingsService slingSettings) {
        this.modes = slingSettings.getRunModes();
    }

    public String getName() {
        return CMD_NAME;
    }

    public String getShortDescription() {
        return "lists current run modes";
    }

    public String getUsage() {
        return CMD_NAME;
    }

    public void execute(String command, PrintStream out, PrintStream err) {
        out.print("Current Run Modes: ");
        if (this.modes == null || this.modes.isEmpty()) {
            out.println("-");
        } else {
            out.println(this.modes);
        }
    }
}

