/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.skywalking.library.elasticsearch.requests.factory;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.InputStream;

/**
 * Responsible to encode requests and decode responses.
 */
public interface Codec {
    byte[] encode(Object request) throws Exception;

    <T> T decode(InputStream inputStream, TypeReference<T> type) throws Exception;

    <T> T decode(InputStream inputStream, Class<T> type) throws Exception;

    default <T> T decode(InputStream inputStream) throws Exception {
        return decode(inputStream, new TypeReference<T>() {
        });
    }
}
