/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.skywalking.oap.server.core.query.type;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

/**
 * create profile task result
 */
@Setter
@Getter
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class AsyncProfilerTaskCreationResult {
    // ErrorReason gives detailed reason for the exception, if the code returned represents a kind of failure.
    private String errorReason;
    // Code defines the status of the response, i.e. success or failure.
    private AsyncProfilerTaskCreationType code;
    // Task id, if code is SUCCESS.
    private String id;
}
