/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.sis.system;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;


/**
 * Controls the preferred service provider when there is more than
 * one implementation of the same Service Provider Interface (SPI).
 * Providers marked with this {@code Fallback} annotation will be used only if there are no other providers.
 * Service providers without this annotation are returned immediately, without scanning other providers.
 *
 * <p>Providers without this annotation are assumed to have a priority of zero.</p>
 *
 * <p>This is not a committed API.
 * The way Apache SIS selects its preferred service provider may change in any future version.</p>
 *
 * @author  Martin Desruisseaux (Geomatys)
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface Fallback {
}
