/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff.reader;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.sis.math.Vector;
import org.apache.sis.referencing.operation.builder.LocalizationGridBuilder;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class Localization {
    static final int RECORD_LENGTH = 6;
    private static final double PRECISION = 1.0E-6;

    private Localization() {
    }

    static MathTransform nonLinear(Vector modelTiePoints) throws FactoryException, TransformException {
        return Localization.localizationGrid(modelTiePoints, null);
    }

    private static MathTransform localizationGrid(Vector modelTiePoints, Map<Envelope, MathTransform> addTo) throws FactoryException, TransformException {
        int size = modelTiePoints.size();
        int n = size / 6;
        if (n == 0) {
            return null;
        }
        Vector x = modelTiePoints.subSampling(0, 6, n);
        Vector y = modelTiePoints.subSampling(1, 6, n);
        try {
            LocalizationGridBuilder grid = new LocalizationGridBuilder(x, y);
            LinearTransform sourceToGrid = grid.getSourceToGrid();
            double[] coordinates = new double[2];
            for (int i = 0; i < size; i += 6) {
                coordinates[0] = modelTiePoints.doubleValue(i);
                coordinates[1] = modelTiePoints.doubleValue(i + 1);
                sourceToGrid.transform(coordinates, 0, coordinates, 0, 1);
                grid.setControlPoint(Math.toIntExact(Math.round(coordinates[0])), Math.toIntExact(Math.round(coordinates[1])), new double[]{modelTiePoints.doubleValue(i + 3), modelTiePoints.doubleValue(i + 4)});
            }
            grid.setDesiredPrecision(1.0E-6);
            MathTransform tr = grid.create(null);
            if (addTo != null && addTo.put(grid.getSourceEnvelope(false), tr) != null) {
                throw new FactoryException();
            }
            return tr;
        }
        catch (ArithmeticException | FactoryException e) {
            HashSet<Double> uniques = new HashSet<Double>(100);
            double splitX = Localization.threshold(x, uniques);
            double splitY = Localization.threshold(y, uniques);
            if (Double.isNaN(splitX) && Double.isNaN(splitY)) {
                throw e;
            }
            int[][] indices = new int[4][size];
            int[] lengths = new int[4];
            int i = 0;
            while (i < size) {
                double px = modelTiePoints.doubleValue(i);
                double py = modelTiePoints.doubleValue(i + 1);
                int part = 0;
                if (px > splitX) {
                    part = 1;
                }
                if (py > splitY) {
                    part |= 2;
                }
                int parts = 1 << part;
                if (px == splitX) {
                    parts |= 1 << (part | 1);
                }
                if (py == splitY) {
                    parts |= 1 << (part | 2);
                }
                if (parts == 7) {
                    parts = 15;
                    assert (px == splitX && py == splitY);
                }
                int upper = i + 6;
                do {
                    part = Integer.numberOfTrailingZeros(parts);
                    int[] tileIndices = indices[part];
                    int k = lengths[part];
                    int j = i;
                    while (j < upper) {
                        tileIndices[k++] = j++;
                    }
                    lengths[part] = k;
                } while ((parts &= ~(1 << part)) != 0);
                i = upper;
            }
            int maxLength = 0;
            int largestPart = 0;
            for (int i2 = 0; i2 < indices.length; ++i2) {
                int length = lengths[i2];
                if (length >= size) {
                    throw e;
                }
                indices[i2] = Arrays.copyOf(indices[i2], length);
                if (length <= maxLength) continue;
                maxLength = length;
                largestPart = i2;
            }
            MathTransform global = null;
            LinkedHashMap<Envelope, MathTransform> specialization = new LinkedHashMap<Envelope, MathTransform>(4);
            for (int i3 = 0; i3 < indices.length; ++i3) {
                Vector sub = modelTiePoints.pick(indices[i3]);
                if (i3 == largestPart) {
                    global = Localization.localizationGrid(sub, null);
                    continue;
                }
                Localization.localizationGrid(sub, specialization);
            }
            return MathTransforms.specialize(global, specialization);
        }
    }

    private static double threshold(Vector values, Set<Double> uniques) {
        int n = values.size();
        for (int i = 0; i < n; ++i) {
            uniques.add(values.doubleValue(i));
        }
        Object[] array = (Double[])uniques.toArray(Double[]::new);
        uniques.clear();
        int i = array.length;
        if (i >= 3) {
            Arrays.sort(array);
            double d = (Double)array[--i];
            double value = (Double)array[--i];
            double inc = d - value;
            do {
                double lower;
                if (value - (lower = ((Double)array[--i]).doubleValue()) != inc) {
                    return value;
                }
                value = lower;
            } while (i > 0);
        }
        return Double.NaN;
    }
}

