---
title: "Snapshot"
weight: 3
type: docs
aliases:
- /concepts/spec/snapshot.html
---
<!--
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
-->

# Snapshot

Each commit generates a snapshot file, and the version of the snapshot file starts from 1 and must be continuous.
`EARLIEST` and `LATEST` are hint files at the beginning and end of the snapshot list, and they can be inaccurate.
When hint files are inaccurate, the read will scan all snapshot files to determine the beginning and end.

```shell
warehouse
└── default.db
    └── my_table
        ├── snapshot
            ├── EARLIEST
            ├── LATEST
            ├── snapshot-1
            ├── snapshot-2
            └── snapshot-3
```

Writing commit will preempt the next snapshot id, and once the snapshot file is successfully written, this commit will
be visible.

Snapshot File is JSON, it includes:

1. version: Snapshot file version, current is 3.
2. id: snapshot id, same to file name.
3. schemaId: the corresponding schema version for this commit.
4. baseManifestList: a manifest list recording all changes from the previous snapshots.
5. deltaManifestList: a manifest list recording all new changes occurred in this snapshot.
6. changelogManifestList: a manifest list recording all changelog produced in this snapshot, null if no changelog is produced.
7. indexManifest: a manifest recording all index files of this table, null if no table index file.
8. commitUser: usually generated by UUID, it is used for recovery of streaming writes, one stream write job with one user.
9. commitIdentifier: transaction id corresponding to streaming write, each transaction may result in multiple commits for different commitKinds.
10. commitKind: type of changes in this snapshot, including append, compact, overwrite and analyze.
11. timeMillis: commit time millis.
12. logOffsets: commit log offsets.
13. totalRecordCount: record count of all changes occurred in this snapshot. 
14. deltaRecordCount: record count of all new changes occurred in this snapshot. 
15. changelogRecordCount: record count of all changelog produced in this snapshot. 
16. watermark: watermark for input records, from Flink watermark mechanism, Long.MIN_VALUE if there is no watermark. 
17. statistics: stats file name for statistics of this table.
