/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.specs.activation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.activation.CommandMap;
import javax.activation.DataContentHandler;
import org.apache.servicemix.specs.activation.OsgiMailcapCommandMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends org.apache.servicemix.specs.locator.Activator {
    private Map<Long, MailCap> mailcaps = new ConcurrentHashMap<Long, MailCap>();

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
        CommandMap.setDefaultCommandMap(null);
    }

    protected void register(Bundle bundle) {
        this.debugPrintln("checking bundle " + bundle.getBundleId());
        URL url = bundle.getResource("/META-INF/mailcap");
        if (url != null) {
            this.debugPrintln("found mailcap at " + url);
            try {
                Class clazz = bundle.loadClass("javax.activation.DataContentHandler");
                if (!clazz.isAssignableFrom(DataContentHandler.class)) {
                    this.debugPrintln("incompatible DataContentHandler class in bundle " + bundle.getBundleId());
                    return;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            try {
                this.mailcaps.put(bundle.getBundleId(), new MailCap(bundle, url));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.rebuildCommandMap();
        }
    }

    protected void unregister(long bundleId) {
        MailCap mailcap = this.mailcaps.remove(bundleId);
        if (mailcap != null) {
            this.debugPrintln("removing mailcap for bundle " + mailcap.bundle.getBundleId());
            this.rebuildCommandMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildCommandMap() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            OsgiMailcapCommandMap commandMap = new OsgiMailcapCommandMap();
            for (MailCap mailcap : this.mailcaps.values()) {
                for (String line : mailcap.lines) {
                    commandMap.addMailcap(line, mailcap.bundle);
                }
            }
            CommandMap.setDefaultCommandMap(commandMap);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    private static class MailCap {
        Bundle bundle;
        List<String> lines;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private MailCap(Bundle bundle, URL url) throws IOException {
            this.bundle = bundle;
            this.lines = new ArrayList<String>();
            InputStream is = url.openStream();
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                while ((line = br.readLine()) != null) {
                    this.lines.add(line);
                }
            }
            finally {
                is.close();
            }
        }
    }
}

