/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.subsystem.sftp.extensions.helpers;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.sshd.client.subsystem.sftp.RawSftpClient;
import org.apache.sshd.client.subsystem.sftp.SftpClient;
import org.apache.sshd.client.subsystem.sftp.extensions.helpers.AbstractSftpClientExtension;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;

public abstract class AbstractCheckFileExtension
extends AbstractSftpClientExtension {
    protected AbstractCheckFileExtension(String name, SftpClient client, RawSftpClient raw, Collection<String> extras) {
        super(name, client, raw, extras);
    }

    protected AbstractMap.SimpleImmutableEntry<String, Collection<byte[]>> doGetHash(Object target, Collection<String> algorithms, long offset, long length, int blockSize) throws IOException {
        Buffer buffer = this.getCommandBuffer(target, 127);
        this.putTarget(buffer, target);
        buffer.putString(GenericUtils.join(algorithms, ','));
        buffer.putLong(offset);
        buffer.putLong(length);
        buffer.putInt(blockSize);
        if (this.log.isDebugEnabled()) {
            this.log.debug("doGetHash({})[{}] - offset={}, length={}, block-size={}", new Object[]{this.getName(), target instanceof CharSequence ? target : BufferUtils.toHex('\u0000', (byte[])target), offset, length, blockSize});
        }
        if ((buffer = this.checkExtendedReplyBuffer(this.receive(this.sendExtendedCommand(buffer)))) == null) {
            throw new StreamCorruptedException("Missing extended reply data");
        }
        String targetType = buffer.getString();
        if (String.CASE_INSENSITIVE_ORDER.compare(targetType, "check-file") != 0) {
            throw new StreamCorruptedException("Mismatched reply type: expected=check-file, actual=" + targetType);
        }
        String algo = buffer.getString();
        LinkedList<byte[]> hashes = new LinkedList<byte[]>();
        while (buffer.available() > 0) {
            byte[] hashValue = buffer.getBytes();
            hashes.add(hashValue);
        }
        return new AbstractMap.SimpleImmutableEntry<String, Collection<byte[]>>(algo, hashes);
    }
}

