/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.impl.objects;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.ontapi.OntJenaException;
import org.apache.jena.ontapi.impl.OntGraphModelImpl;
import org.apache.jena.ontapi.impl.objects.OntObjectImpl;
import org.apache.jena.ontapi.impl.objects.OntStatementImpl;
import org.apache.jena.ontapi.model.OntAnnotation;
import org.apache.jena.ontapi.model.OntAnnotationProperty;
import org.apache.jena.ontapi.model.OntObject;
import org.apache.jena.ontapi.model.OntStatement;
import org.apache.jena.ontapi.utils.Iterators;
import org.apache.jena.ontapi.utils.StdModels;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.OWL2;
import org.apache.jena.vocabulary.RDF;

public class OntAnnotationImpl
extends OntObjectImpl
implements OntAnnotation {
    public static final Set<Property> REQUIRED_PROPERTIES = Set.of(OWL2.annotatedSource, OWL2.annotatedProperty, OWL2.annotatedTarget);
    public static final Set<Property> SPEC = Stream.concat(Stream.of(RDF.type), REQUIRED_PROPERTIES.stream()).collect(Collectors.toUnmodifiableSet());
    public static final Comparator<OntAnnotation> DEFAULT_ANNOTATION_COMPARATOR = (left, right) -> {
        Set leftSet = OntAnnotationImpl.listRelatedStatements(left).toSet();
        Set rightSet = OntAnnotationImpl.listRelatedStatements(right).toSet();
        int res = Integer.compare(leftSet.size(), rightSet.size());
        while (res == 0) {
            OntStatement s1 = (OntStatement)OntAnnotationImpl.removeMin(leftSet, StdModels.STATEMENT_COMPARATOR_IGNORE_BLANK);
            OntStatement s2 = (OntStatement)OntAnnotationImpl.removeMin(rightSet, StdModels.STATEMENT_COMPARATOR_IGNORE_BLANK);
            res = StdModels.STATEMENT_COMPARATOR_IGNORE_BLANK.compare(s1, s2);
            if (!leftSet.isEmpty() && !rightSet.isEmpty()) continue;
            break;
        }
        return -res;
    };
    public static final Set<Resource> EXTRA_ROOT_TYPES = Set.of(OWL2.AllDisjointClasses, OWL2.AllDisjointProperties, OWL2.AllDifferent, OWL2.NegativePropertyAssertion);
    public static final List<Resource> ROOT_TYPES = Stream.concat(Stream.of(OWL2.Axiom, OWL2.Annotation), EXTRA_ROOT_TYPES.stream()).toList();

    public OntAnnotationImpl(Node n, EnhGraph m) {
        super(n, m);
    }

    public static OntAnnotation createAnnotation(Model model, Statement base, Resource type) {
        Resource res = Objects.requireNonNull(model).createResource();
        if (!model.contains(Objects.requireNonNull(base))) {
            throw new OntJenaException.IllegalArgument("Can't find " + StdModels.toString(base));
        }
        res.addProperty(RDF.type, (RDFNode)type);
        res.addProperty(OWL2.annotatedSource, (RDFNode)base.getSubject());
        res.addProperty(OWL2.annotatedProperty, (RDFNode)base.getPredicate());
        res.addProperty(OWL2.annotatedTarget, base.getObject());
        return (OntAnnotation)res.as(OntAnnotation.class);
    }

    private static <S> S removeMin(Set<S> notEmptySet, Comparator<? super S> comparator) throws IllegalStateException {
        S res = notEmptySet.stream().min(comparator).orElseThrow(IllegalStateException::new);
        if (!notEmptySet.remove(res)) {
            throw new IllegalStateException();
        }
        return res;
    }

    public static ExtendedIterator<OntStatement> listRelatedStatements(OntAnnotation annotation) {
        OntAnnotationImpl a = (OntAnnotationImpl)annotation;
        return a.listAssertions().andThen((Iterator)a.listDescendants().mapWith(OntObject::getMainStatement));
    }

    @Override
    public ExtendedIterator<OntStatement> listSpec() {
        return this.listStatements().filterKeep(s -> SPEC.contains(s.getPredicate()) || s.isAnnotationAssertion());
    }

    @Override
    public OntStatement getBase() {
        if (!this.hasType(OWL2.Axiom) && !this.hasType(OWL2.Annotation)) {
            return null;
        }
        Resource s = this.getRequiredObject(OWL2.annotatedSource, Resource.class);
        Property p = this.getRequiredObject(OWL2.annotatedProperty, Property.class);
        RDFNode o = this.getRequiredObject(OWL2.annotatedTarget, RDFNode.class);
        return this.getModel().createStatement(s, p, o);
    }

    @Override
    public ExtendedIterator<OntStatement> listAssertions() {
        return this.listStatements().filterKeep(s -> !SPEC.contains(s.getPredicate()) && s.isAnnotationAssertion());
    }

    @Override
    public ExtendedIterator<OntStatement> listAnnotations() {
        return this.listAssertions();
    }

    @Override
    public Stream<OntAnnotation> descendants() {
        return Iterators.asStream(this.listDescendants(), this.getCharacteristics());
    }

    public ExtendedIterator<OntAnnotation> listDescendants() {
        OntGraphModelImpl m = this.getModel();
        return this.listAnnotatedSources().mapWith(s -> m.findNodeAs(((OntStatementImpl)s).getSubjectNode(), OntAnnotation.class)).filterDrop(Objects::isNull);
    }

    protected ExtendedIterator<OntStatement> listAnnotatedSources() {
        return this.getModel().listOntStatements(null, OWL2.annotatedSource, (RDFNode)this);
    }

    @Override
    public OntStatement addAnnotation(OntAnnotationProperty property, RDFNode value) {
        return this.getModel().add((Resource)this, (Property)property, value).createStatement(this, property, value);
    }

    @Override
    public Class<? extends OntObject> objectType() {
        return OntAnnotation.class;
    }
}

