/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.event.batch;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.subscription.broker.SubscriptionPrefetchingQueue;
import org.apache.iotdb.db.subscription.broker.SubscriptionPrefetchingTabletQueue;
import org.apache.iotdb.db.subscription.broker.SubscriptionPrefetchingTsFileQueue;
import org.apache.iotdb.db.subscription.event.SubscriptionEvent;
import org.apache.iotdb.db.subscription.event.batch.SubscriptionPipeEventBatch;
import org.apache.iotdb.db.subscription.event.batch.SubscriptionPipeEventBatchSegmentLock;
import org.apache.iotdb.db.subscription.event.batch.SubscriptionPipeTabletEventBatch;
import org.apache.iotdb.db.subscription.event.batch.SubscriptionPipeTsFileEventBatch;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionPipeEventBatches {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionPipeEventBatches.class);
    protected final SubscriptionPrefetchingQueue prefetchingQueue;
    protected final int maxDelayInMs;
    protected final long maxBatchSizeInBytes;
    private final Map<Integer, SubscriptionPipeEventBatch> regionIdToBatch;
    private final SubscriptionPipeEventBatchSegmentLock segmentLock;

    public SubscriptionPipeEventBatches(SubscriptionPrefetchingQueue prefetchingQueue, int maxDelayInMs, long maxBatchSizeInBytes) {
        this.prefetchingQueue = prefetchingQueue;
        this.maxDelayInMs = maxDelayInMs;
        this.maxBatchSizeInBytes = maxBatchSizeInBytes;
        this.regionIdToBatch = new HashMap<Integer, SubscriptionPipeEventBatch>();
        this.segmentLock = new SubscriptionPipeEventBatchSegmentLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onEvent(Consumer<SubscriptionEvent> consumer) {
        AtomicBoolean hasNew = new AtomicBoolean(false);
        UnmodifiableIterator unmodifiableIterator = ImmutableList.copyOf(this.regionIdToBatch.keySet()).iterator();
        while (unmodifiableIterator.hasNext()) {
            int regionId = (Integer)unmodifiableIterator.next();
            try {
                this.segmentLock.lock(regionId);
                SubscriptionPipeEventBatch batch = this.regionIdToBatch.get(regionId);
                if (Objects.isNull(batch)) continue;
                try {
                    if (batch.onEvent(consumer)) {
                        hasNew.set(true);
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Exception occurred when sealing events from batch {}", (Object)batch, (Object)e);
                }
                if (!hasNew.get()) continue;
                this.regionIdToBatch.remove(regionId);
                break;
            }
            finally {
                this.segmentLock.unlock(regionId);
            }
        }
        return hasNew.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onEvent(@NonNull EnrichedEvent event, Consumer<SubscriptionEvent> consumer) throws Exception {
        int regionId = event.getCommitterKey().getRegionId();
        AtomicBoolean hasNew = new AtomicBoolean(false);
        try {
            this.segmentLock.lock(regionId);
            SubscriptionPipeEventBatch batch = this.regionIdToBatch.get(regionId);
            if (Objects.isNull(batch)) {
                try {
                    batch = this.prefetchingQueue instanceof SubscriptionPrefetchingTabletQueue ? new SubscriptionPipeTabletEventBatch(regionId, (SubscriptionPrefetchingTabletQueue)this.prefetchingQueue, this.maxDelayInMs, this.maxBatchSizeInBytes) : new SubscriptionPipeTsFileEventBatch(regionId, (SubscriptionPrefetchingTsFileQueue)this.prefetchingQueue, this.maxDelayInMs, this.maxBatchSizeInBytes);
                }
                catch (Exception e) {
                    LOGGER.warn("Exception occurred when construct new batch", (Throwable)e);
                    throw e;
                }
            }
            try {
                if (batch.onEvent(event, consumer)) {
                    hasNew.set(true);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Exception occurred when sealing events from batch {}", (Object)batch, (Object)e);
            }
            if (hasNew.get()) {
                this.regionIdToBatch.remove(regionId);
            } else {
                this.regionIdToBatch.put(regionId, batch);
            }
        }
        finally {
            this.segmentLock.unlock(regionId);
        }
        return hasNew.get();
    }

    public void cleanUp() {
        this.regionIdToBatch.values().forEach(batch -> batch.cleanUp(true));
        this.regionIdToBatch.clear();
    }
}

