/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.encoding.encoder;

import java.io.ByteArrayOutputStream;
import org.apache.tsfile.encoding.encoder.GorillaEncoderV2;

public class IntGorillaEncoder
extends GorillaEncoderV2 {
    private static final int ONE_ITEM_MAX_SIZE = 6;
    private int storedValue = 0;

    @Override
    public final int getOneItemMaxSize() {
        return 6;
    }

    @Override
    public final void encode(int value, ByteArrayOutputStream out) {
        if (this.firstValueWasWritten) {
            this.compressValue(value, out);
        } else {
            this.writeFirst(value, out);
            this.firstValueWasWritten = true;
        }
    }

    @Override
    public void flush(ByteArrayOutputStream out) {
        this.encode(Integer.MIN_VALUE, out);
        this.bitsLeft = 0;
        this.flipByte(out);
        this.reset();
    }

    @Override
    protected void reset() {
        super.reset();
        this.storedValue = 0;
    }

    private void writeFirst(int value, ByteArrayOutputStream out) {
        this.storedValue = value;
        this.writeBits(value, 32, out);
    }

    private void compressValue(int value, ByteArrayOutputStream out) {
        int xor = this.storedValue ^ value;
        this.storedValue = value;
        if (xor == 0) {
            this.skipBit(out);
        } else {
            this.writeBit(out);
            int leadingZeros = Integer.numberOfLeadingZeros(xor);
            int trailingZeros = Integer.numberOfTrailingZeros(xor);
            if (leadingZeros >= this.storedLeadingZeros && trailingZeros >= this.storedTrailingZeros) {
                this.writeExistingLeading(xor, out);
            } else {
                this.writeNewLeading(xor, leadingZeros, trailingZeros, out);
            }
        }
    }

    private void writeExistingLeading(int xor, ByteArrayOutputStream out) {
        this.skipBit(out);
        int significantBits = 32 - this.storedLeadingZeros - this.storedTrailingZeros;
        this.writeBits(xor >>> this.storedTrailingZeros, significantBits, out);
    }

    private void writeNewLeading(int xor, int leadingZeros, int trailingZeros, ByteArrayOutputStream out) {
        this.writeBit(out);
        int significantBits = 32 - leadingZeros - trailingZeros;
        this.writeBits(leadingZeros, 5, out);
        this.writeBits((long)significantBits - 1L, 5, out);
        this.writeBits(xor >>> trailingZeros, significantBits, out);
        this.storedLeadingZeros = leadingZeros;
        this.storedTrailingZeros = trailingZeros;
    }
}

