/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.table;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public enum TsTableInternalRPCType {
    PRE_UPDATE_TABLE(0),
    ROLLBACK_UPDATE_TABLE(1),
    COMMIT_UPDATE_TABLE(2);

    private final byte operationType;

    private TsTableInternalRPCType(byte operationType) {
        this.operationType = operationType;
    }

    public byte getOperationType() {
        return this.operationType;
    }

    public void serialize(OutputStream stream) throws IOException {
        ReadWriteIOUtils.write((byte)this.operationType, (OutputStream)stream);
    }

    public static TsTableInternalRPCType deserialize(ByteBuffer buffer) {
        byte type = ReadWriteIOUtils.readByte((ByteBuffer)buffer);
        return TsTableInternalRPCType.getType(type);
    }

    public static TsTableInternalRPCType getType(byte type) {
        switch (type) {
            case 0: {
                return PRE_UPDATE_TABLE;
            }
            case 1: {
                return ROLLBACK_UPDATE_TABLE;
            }
            case 2: {
                return COMMIT_UPDATE_TABLE;
            }
        }
        throw new IllegalArgumentException("Unknown table update operation type" + type);
    }
}

