/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.expression;

import java.util.List;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.expression.Computation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DataType;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.GenericDataType;

public class CastComputation
extends Computation {
    private final Computation inner;
    private final DataType targetType;

    public CastComputation(Computation inner, DataType targetType) {
        this.inner = inner;
        this.targetType = targetType;
    }

    @Override
    public Object evaluate(List<Object> values) {
        Object value = this.inner.evaluate(values);
        if (value == null) {
            return null;
        }
        if (this.targetType instanceof GenericDataType) {
            String typeName;
            switch (typeName = ((GenericDataType)this.targetType).getName().getValue().toUpperCase()) {
                case "INT32": {
                    if (value instanceof Number) {
                        return ((Number)value).intValue();
                    }
                    return Integer.parseInt(value.toString());
                }
                case "INT64": {
                    if (value instanceof Number) {
                        return ((Number)value).longValue();
                    }
                    return Long.parseLong(value.toString());
                }
                case "FLOAT": {
                    if (value instanceof Number) {
                        return Float.valueOf(((Number)value).floatValue());
                    }
                    return Float.valueOf(Float.parseFloat(value.toString()));
                }
                case "DOUBLE": {
                    if (value instanceof Number) {
                        return ((Number)value).doubleValue();
                    }
                    return Double.parseDouble(value.toString());
                }
                case "STRING": {
                    return value.toString();
                }
                case "BOOLEAN": {
                    if (value instanceof Boolean) {
                        return value;
                    }
                    return Boolean.parseBoolean(value.toString());
                }
            }
            throw new UnsupportedOperationException("Unsupported cast to type: " + typeName);
        }
        throw new UnsupportedOperationException("Target type is not a GenericDataType: " + this.targetType);
    }
}

