/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.executor;

import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.consensus.IConsensus;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.exception.ConsensusGroupNotExistException;
import org.apache.iotdb.db.consensus.DataRegionConsensusImpl;
import org.apache.iotdb.db.consensus.SchemaRegionConsensusImpl;
import org.apache.iotdb.db.queryengine.execution.executor.RegionExecutionResult;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceInfo;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceManager;
import org.apache.iotdb.db.queryengine.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.storageengine.dataregion.VirtualDataRegion;
import org.apache.iotdb.db.utils.ErrorHandlingUtils;
import org.apache.iotdb.db.utils.SetThreadName;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.apache.ratis.protocol.exceptions.ReadException;
import org.apache.ratis.protocol.exceptions.ReadIndexException;
import org.apache.ratis.protocol.exceptions.ServerNotReadyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionReadExecutor {
    public static final String RESPONSE_NULL_ERROR_MSG = "ReadResponse is null";
    public static final String ERROR_MSG_FORMAT = "Execute FragmentInstance failed: %s";
    private static final Logger LOGGER = LoggerFactory.getLogger(RegionReadExecutor.class);
    private final IConsensus dataRegionConsensus;
    private final IConsensus schemaRegionConsensus;
    private final FragmentInstanceManager fragmentInstanceManager;

    public RegionReadExecutor() {
        this.dataRegionConsensus = DataRegionConsensusImpl.getInstance();
        this.schemaRegionConsensus = SchemaRegionConsensusImpl.getInstance();
        this.fragmentInstanceManager = FragmentInstanceManager.getInstance();
    }

    public RegionReadExecutor(IConsensus dataRegionConsensus, IConsensus schemaRegionConsensus, FragmentInstanceManager fragmentInstanceManager) {
        this.dataRegionConsensus = dataRegionConsensus;
        this.schemaRegionConsensus = schemaRegionConsensus;
        this.fragmentInstanceManager = fragmentInstanceManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RegionExecutionResult execute(ConsensusGroupId groupId, FragmentInstance fragmentInstance) {
        try (SetThreadName threadName = new SetThreadName(fragmentInstance.getId().getFullId());){
            DataSet readResponse222;
            if (groupId instanceof DataRegionId) {
                DataSet readResponse = this.dataRegionConsensus.read(groupId, (IConsensusRequest)fragmentInstance);
            } else {
                readResponse222 = this.schemaRegionConsensus.read(groupId, (IConsensusRequest)fragmentInstance);
            }
            if (readResponse222 == null) {
                LOGGER.error(RESPONSE_NULL_ERROR_MSG);
                RegionExecutionResult regionExecutionResult = RegionExecutionResult.create(false, RESPONSE_NULL_ERROR_MSG, null);
                return regionExecutionResult;
            }
            FragmentInstanceInfo info222 = (FragmentInstanceInfo)readResponse222;
            RegionExecutionResult resp = RegionExecutionResult.create(!info222.getState().isFailed(), info222.getMessage(), null);
            info222.getErrorCode().ifPresent(s -> {
                resp.setStatus((TSStatus)s);
                resp.setReadNeedRetry(StatusUtils.needRetryHelper((TSStatus)s));
            });
            RegionExecutionResult regionExecutionResult = resp;
            return regionExecutionResult;
        }
        catch (ConsensusGroupNotExistException e) {
            LOGGER.warn("Execute FragmentInstance in ConsensusGroup {} failed.", (Object)groupId, (Object)e);
            String errorMsg = String.format(ERROR_MSG_FORMAT, e.getMessage());
            RegionExecutionResult resp2 = RegionExecutionResult.create(false, errorMsg, new TSStatus(TSStatusCode.CONSENSUS_GROUP_NOT_EXIST.getStatusCode()).setMessage(errorMsg));
            resp2.setReadNeedRetry(true);
            return resp2;
        }
        catch (Throwable e) {
            LOGGER.warn("Execute FragmentInstance in ConsensusGroup {} failed.", (Object)groupId, (Object)e);
            RegionExecutionResult resp3 = RegionExecutionResult.create(false, String.format(ERROR_MSG_FORMAT, e.getMessage()), null);
            Throwable t = ErrorHandlingUtils.getRootCause(e);
            if (!(t instanceof ReadException || t instanceof ReadIndexException || t instanceof NotLeaderException || t instanceof ServerNotReadyException)) {
                if (!(t instanceof InterruptedException)) return resp3;
            }
            resp3.setReadNeedRetry(true);
            resp3.setStatus(new TSStatus(TSStatusCode.RATIS_READ_UNAVAILABLE.getStatusCode()));
            return resp3;
        }
    }

    public RegionExecutionResult execute(FragmentInstance fragmentInstance) {
        SetThreadName threadName = new SetThreadName(fragmentInstance.getId().getFullId());
        try {
            FragmentInstanceInfo info = this.fragmentInstanceManager.execDataQueryFragmentInstance(fragmentInstance, VirtualDataRegion.getInstance());
            RegionExecutionResult regionExecutionResult = RegionExecutionResult.create(!info.getState().isFailed(), info.getMessage(), null);
            threadName.close();
            return regionExecutionResult;
        }
        catch (Throwable throwable) {
            try {
                try {
                    threadName.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable t) {
                LOGGER.error("Execute FragmentInstance in QueryExecutor failed.", t);
                return RegionExecutionResult.create(false, String.format(ERROR_MSG_FORMAT, t.getMessage()), null);
            }
        }
    }
}

