/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.cache.node;

import java.util.Objects;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.confignode.manager.load.cache.AbstractStatistics;

public class NodeStatistics
extends AbstractStatistics {
    private final NodeStatus status;
    private final String statusReason;
    private final long loadScore;

    public NodeStatistics(long statisticsNanoTimestamp, NodeStatus status, String statusReason, long loadScore) {
        super(statisticsNanoTimestamp);
        this.status = status;
        this.statusReason = statusReason;
        this.loadScore = loadScore;
    }

    public NodeStatistics(NodeStatus status) {
        super(System.nanoTime());
        this.status = status;
        this.statusReason = null;
        this.loadScore = Long.MAX_VALUE;
    }

    public static NodeStatistics generateDefaultNodeStatistics() {
        return new NodeStatistics(Long.MIN_VALUE, NodeStatus.Unknown, null, Long.MAX_VALUE);
    }

    public NodeStatus getStatus() {
        return this.status;
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public long getLoadScore() {
        return this.loadScore;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeStatistics that = (NodeStatistics)o;
        return this.status == that.status && Objects.equals(this.statusReason, that.statusReason);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.statusReason, this.loadScore);
    }

    public String toString() {
        return "NodeStatistics{status=" + this.status + ", statusReason='" + this.statusReason + '\'' + '}';
    }
}

