/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.diagnostics;

import java.util.concurrent.atomic.LongAdder;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.diagnostics.ServiceCounter;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.structured.ApplicationDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.SessionDiagnosticsDataType;

public class SessionDiagnostics {
    private final ServiceCounter totalRequestCount = new ServiceCounter();
    private final LongAdder unauthorizedRequestCount = new LongAdder();
    private final ServiceCounter readCount = new ServiceCounter();
    private final ServiceCounter historyReadCount = new ServiceCounter();
    private final ServiceCounter writeCount = new ServiceCounter();
    private final ServiceCounter historyUpdateCount = new ServiceCounter();
    private final ServiceCounter callCount = new ServiceCounter();
    private final ServiceCounter createMonitoredItemsCount = new ServiceCounter();
    private final ServiceCounter modifyMonitoredItemsCount = new ServiceCounter();
    private final ServiceCounter setMonitoringModeCount = new ServiceCounter();
    private final ServiceCounter setTriggeringCount = new ServiceCounter();
    private final ServiceCounter deleteMonitoredItemsCount = new ServiceCounter();
    private final ServiceCounter createSubscriptionCount = new ServiceCounter();
    private final ServiceCounter modifySubscriptionCount = new ServiceCounter();
    private final ServiceCounter setPublishingModeCount = new ServiceCounter();
    private final ServiceCounter publishCount = new ServiceCounter();
    private final ServiceCounter republishCount = new ServiceCounter();
    private final ServiceCounter transferSubscriptionsCount = new ServiceCounter();
    private final ServiceCounter deleteSubscriptionsCount = new ServiceCounter();
    private final ServiceCounter addNodesCount = new ServiceCounter();
    private final ServiceCounter addReferencesCount = new ServiceCounter();
    private final ServiceCounter deleteNodesCount = new ServiceCounter();
    private final ServiceCounter deleteReferencesCount = new ServiceCounter();
    private final ServiceCounter browseCount = new ServiceCounter();
    private final ServiceCounter browseNextCount = new ServiceCounter();
    private final ServiceCounter translateBrowsePathsToNodeIdsCount = new ServiceCounter();
    private final ServiceCounter queryFirstCount = new ServiceCounter();
    private final ServiceCounter queryNextCount = new ServiceCounter();
    private final ServiceCounter registerNodesCount = new ServiceCounter();
    private final ServiceCounter unregisterNodesCount = new ServiceCounter();
    private final Session session;

    public SessionDiagnostics(Session session) {
        this.session = session;
    }

    public NodeId getSessionId() {
        return this.session.getSessionId();
    }

    public String getSessionName() {
        return this.session.getSessionName();
    }

    public ApplicationDescription getClientDescription() {
        return this.session.getClientDescription();
    }

    public String getServerUri() {
        return this.session.getServerUri();
    }

    public String getEndpointUrl() {
        return this.session.getEndpoint().getEndpointUrl();
    }

    public String[] getLocaleIds() {
        return this.session.getLocaleIds();
    }

    public Double getActualSessionTimeout() {
        return this.session.getSessionTimeout();
    }

    public UInteger getMaxResponseMessageSize() {
        return this.session.getMaxResponseMessageSize();
    }

    public DateTime getClientConnectionTime() {
        return this.session.getConnectionTime();
    }

    public DateTime getClientLastContactTime() {
        return this.session.getLastContactTime();
    }

    public UInteger getCurrentSubscriptionsCount() {
        return Unsigned.uint((int)this.session.getSubscriptionManager().getSubscriptions().size());
    }

    public UInteger getCurrentMonitoredItemsCount() {
        return Unsigned.uint((int)this.session.getSubscriptionManager().getSubscriptions().stream().map(s -> s.getMonitoredItems().size()).reduce(Integer::sum).orElse(0));
    }

    public UInteger getCurrentPublishRequestsInQueue() {
        return Unsigned.uint((int)this.session.getSubscriptionManager().getPublishQueue().size());
    }

    public ServiceCounter getTotalRequestCount() {
        return this.totalRequestCount;
    }

    public LongAdder getUnauthorizedRequestCount() {
        return this.unauthorizedRequestCount;
    }

    public ServiceCounter getReadCount() {
        return this.readCount;
    }

    public ServiceCounter getHistoryReadCount() {
        return this.historyReadCount;
    }

    public ServiceCounter getWriteCount() {
        return this.writeCount;
    }

    public ServiceCounter getHistoryUpdateCount() {
        return this.historyUpdateCount;
    }

    public ServiceCounter getCallCount() {
        return this.callCount;
    }

    public ServiceCounter getCreateMonitoredItemsCount() {
        return this.createMonitoredItemsCount;
    }

    public ServiceCounter getModifyMonitoredItemsCount() {
        return this.modifyMonitoredItemsCount;
    }

    public ServiceCounter getSetMonitoringModeCount() {
        return this.setMonitoringModeCount;
    }

    public ServiceCounter getSetTriggeringCount() {
        return this.setTriggeringCount;
    }

    public ServiceCounter getDeleteMonitoredItemsCount() {
        return this.deleteMonitoredItemsCount;
    }

    public ServiceCounter getCreateSubscriptionCount() {
        return this.createSubscriptionCount;
    }

    public ServiceCounter getModifySubscriptionCount() {
        return this.modifySubscriptionCount;
    }

    public ServiceCounter getSetPublishingModeCount() {
        return this.setPublishingModeCount;
    }

    public ServiceCounter getPublishCount() {
        return this.publishCount;
    }

    public ServiceCounter getRepublishCount() {
        return this.republishCount;
    }

    public ServiceCounter getTransferSubscriptionsCount() {
        return this.transferSubscriptionsCount;
    }

    public ServiceCounter getDeleteSubscriptionsCount() {
        return this.deleteSubscriptionsCount;
    }

    public ServiceCounter getAddNodesCount() {
        return this.addNodesCount;
    }

    public ServiceCounter getAddReferencesCount() {
        return this.addReferencesCount;
    }

    public ServiceCounter getDeleteNodesCount() {
        return this.deleteNodesCount;
    }

    public ServiceCounter getDeleteReferencesCount() {
        return this.deleteReferencesCount;
    }

    public ServiceCounter getBrowseCount() {
        return this.browseCount;
    }

    public ServiceCounter getBrowseNextCount() {
        return this.browseNextCount;
    }

    public ServiceCounter getTranslateBrowsePathsToNodeIdsCount() {
        return this.translateBrowsePathsToNodeIdsCount;
    }

    public ServiceCounter getQueryFirstCount() {
        return this.queryFirstCount;
    }

    public ServiceCounter getQueryNextCount() {
        return this.queryNextCount;
    }

    public ServiceCounter getRegisterNodesCount() {
        return this.registerNodesCount;
    }

    public ServiceCounter getUnregisterNodesCount() {
        return this.unregisterNodesCount;
    }

    public SessionDiagnosticsDataType getSessionDiagnosticsDataType() {
        return new SessionDiagnosticsDataType(this.getSessionId(), this.getSessionName(), this.getClientDescription(), this.getServerUri(), this.getEndpointUrl(), this.getLocaleIds(), this.getActualSessionTimeout(), this.getMaxResponseMessageSize(), this.getClientConnectionTime(), this.getClientLastContactTime(), this.getCurrentSubscriptionsCount(), this.getCurrentMonitoredItemsCount(), this.getCurrentPublishRequestsInQueue(), this.getTotalRequestCount().getServiceCounter(), Unsigned.uint((long)this.getUnauthorizedRequestCount().sum()), this.getReadCount().getServiceCounter(), this.getHistoryReadCount().getServiceCounter(), this.getWriteCount().getServiceCounter(), this.getHistoryUpdateCount().getServiceCounter(), this.getCallCount().getServiceCounter(), this.getCreateMonitoredItemsCount().getServiceCounter(), this.getModifyMonitoredItemsCount().getServiceCounter(), this.getSetMonitoringModeCount().getServiceCounter(), this.getSetTriggeringCount().getServiceCounter(), this.getDeleteMonitoredItemsCount().getServiceCounter(), this.getCreateSubscriptionCount().getServiceCounter(), this.getModifySubscriptionCount().getServiceCounter(), this.getSetPublishingModeCount().getServiceCounter(), this.getPublishCount().getServiceCounter(), this.getRepublishCount().getServiceCounter(), this.getTransferSubscriptionsCount().getServiceCounter(), this.getDeleteSubscriptionsCount().getServiceCounter(), this.getAddNodesCount().getServiceCounter(), this.getAddReferencesCount().getServiceCounter(), this.getDeleteNodesCount().getServiceCounter(), this.getDeleteReferencesCount().getServiceCounter(), this.getBrowseCount().getServiceCounter(), this.getBrowseNextCount().getServiceCounter(), this.getTranslateBrowsePathsToNodeIdsCount().getServiceCounter(), this.getQueryFirstCount().getServiceCounter(), this.getQueryNextCount().getServiceCounter(), this.getRegisterNodesCount().getServiceCounter(), this.getUnregisterNodesCount().getServiceCounter());
    }
}

