/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tsfile.container.scan;

import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PatternTreeMap;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.datastructure.pattern.PipePattern;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.container.TsFileInsertionDataContainer;
import org.apache.iotdb.db.pipe.event.common.tsfile.container.scan.AlignedSinglePageWholeChunkReader;
import org.apache.iotdb.db.pipe.event.common.tsfile.container.scan.SinglePageWholeChunkReader;
import org.apache.iotdb.db.pipe.event.common.tsfile.parser.util.ModsOperationUtil;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryBlock;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryWeightUtil;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionPathUtils;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.utils.datastructure.PatternTreeMapFactory;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.MetaMarker;
import org.apache.tsfile.file.header.ChunkHeader;
import org.apache.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.PlainDeviceID;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.common.BatchData;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.read.common.Path;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.reader.IChunkReader;
import org.apache.tsfile.read.reader.chunk.AlignedChunkReader;
import org.apache.tsfile.read.reader.chunk.ChunkReader;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.DateUtils;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.TsPrimitiveType;
import org.apache.tsfile.write.UnSupportedDataTypeException;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileInsertionScanDataContainer
extends TsFileInsertionDataContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModsOperationUtil.class);
    private static final LocalDate EMPTY_DATE = LocalDate.of(1000, 1, 1);
    private final long startTime;
    private final long endTime;
    private final Filter filter;
    private IChunkReader chunkReader;
    private BatchData data;
    private final PipeMemoryBlock allocatedMemoryBlockForBatchData;
    private final PipeMemoryBlock allocatedMemoryBlockForChunk;
    private boolean currentIsMultiPage;
    private String currentDevice;
    private boolean currentIsAligned;
    private final List<MeasurementSchema> currentMeasurements = new ArrayList<MeasurementSchema>();
    private final List<ModsOperationUtil.ModsInfo> modsInfos = new ArrayList<ModsOperationUtil.ModsInfo>();
    private final List<Chunk> timeChunkList = new ArrayList<Chunk>();
    private final List<Boolean> isMultiPageList = new ArrayList<Boolean>();
    private final Map<String, Integer> measurementIndexMap = new HashMap<String, Integer>();
    private int lastIndex = -1;
    private ChunkHeader firstChunkHeader4NextSequentialValueChunks;
    private byte lastMarker = (byte)-128;

    public TsFileInsertionScanDataContainer(String pipeName, long creationTime, File tsFile, PipePattern pattern, long startTime, long endTime, PipeTaskMeta pipeTaskMeta, EnrichedEvent sourceEvent, boolean isWithMod) throws IOException {
        super(pipeName, creationTime, pattern, startTime, endTime, pipeTaskMeta, sourceEvent);
        this.startTime = startTime;
        this.endTime = endTime;
        this.filter = Objects.nonNull(this.timeFilterExpression) ? this.timeFilterExpression.getFilter() : null;
        this.allocatedMemoryBlockForBatchData = PipeDataNodeResourceManager.memory().forceAllocateForTabletWithRetry(PipeConfig.getInstance().getPipeDataStructureTabletSizeInBytes());
        this.allocatedMemoryBlockForChunk = PipeDataNodeResourceManager.memory().forceAllocateForTabletWithRetry(PipeConfig.getInstance().getPipeMaxReaderChunkSize());
        try {
            this.currentModifications = isWithMod ? ModsOperationUtil.loadModificationsFromTsFile(tsFile) : PatternTreeMapFactory.getModsPatternTreeMap();
            this.allocatedMemoryBlockForModifications = PipeDataNodeResourceManager.memory().forceAllocateForTabletWithRetry(this.currentModifications.ramBytesUsed());
            this.tsFileSequenceReader = new TsFileSequenceReader(tsFile.getAbsolutePath(), !this.currentModifications.isEmpty(), !this.currentModifications.isEmpty());
            this.tsFileSequenceReader.position((long)"TsFile".getBytes().length + 1L);
            this.prepareData();
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    public TsFileInsertionScanDataContainer(File tsFile, PipePattern pattern, long startTime, long endTime, PipeTaskMeta pipeTaskMeta, EnrichedEvent sourceEvent, boolean isWithMod) throws IOException {
        this(null, 0L, tsFile, pattern, startTime, endTime, pipeTaskMeta, sourceEvent, isWithMod);
    }

    @Override
    public Iterable<TabletInsertionEvent> toTabletInsertionEvents() {
        if (this.tabletInsertionIterable == null) {
            this.tabletInsertionIterable = () -> new Iterator<TabletInsertionEvent>(){

                @Override
                public boolean hasNext() {
                    boolean hasNext = Objects.nonNull(TsFileInsertionScanDataContainer.this.chunkReader);
                    if (hasNext && !TsFileInsertionScanDataContainer.this.parseStartTimeRecorded) {
                        TsFileInsertionScanDataContainer.this.recordParseStartTime();
                    } else if (!hasNext && TsFileInsertionScanDataContainer.this.parseStartTimeRecorded && !TsFileInsertionScanDataContainer.this.parseEndTimeRecorded) {
                        TsFileInsertionScanDataContainer.this.recordParseEndTime();
                    }
                    return hasNext;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public TabletInsertionEvent next() {
                    if (!this.hasNext()) {
                        TsFileInsertionScanDataContainer.this.close();
                        throw new NoSuchElementException();
                    }
                    boolean isAligned = TsFileInsertionScanDataContainer.this.currentIsAligned;
                    Tablet tablet = TsFileInsertionScanDataContainer.this.getNextTablet();
                    TsFileInsertionScanDataContainer.this.recordTabletMetrics(tablet);
                    boolean hasNext = this.hasNext();
                    try {
                        PipeRawTabletInsertionEvent pipeRawTabletInsertionEvent = new PipeRawTabletInsertionEvent(tablet, isAligned, TsFileInsertionScanDataContainer.this.sourceEvent != null ? TsFileInsertionScanDataContainer.this.sourceEvent.getPipeName() : null, TsFileInsertionScanDataContainer.this.sourceEvent != null ? TsFileInsertionScanDataContainer.this.sourceEvent.getCreationTime() : 0L, TsFileInsertionScanDataContainer.this.pipeTaskMeta, TsFileInsertionScanDataContainer.this.sourceEvent, !hasNext);
                        return pipeRawTabletInsertionEvent;
                    }
                    finally {
                        if (!hasNext) {
                            TsFileInsertionScanDataContainer.this.close();
                        }
                    }
                }
            };
        }
        return this.tabletInsertionIterable;
    }

    public Iterable<Pair<Tablet, Boolean>> toTabletWithIsAligneds() {
        return () -> new Iterator<Pair<Tablet, Boolean>>(){

            @Override
            public boolean hasNext() {
                return Objects.nonNull(TsFileInsertionScanDataContainer.this.chunkReader);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Pair<Tablet, Boolean> next() {
                if (!this.hasNext()) {
                    TsFileInsertionScanDataContainer.this.close();
                    throw new NoSuchElementException();
                }
                boolean isAligned = TsFileInsertionScanDataContainer.this.currentIsAligned;
                Tablet tablet = TsFileInsertionScanDataContainer.this.getNextTablet();
                boolean hasNext = this.hasNext();
                try {
                    Pair pair = new Pair((Object)tablet, (Object)isAligned);
                    return pair;
                }
                finally {
                    if (!hasNext) {
                        TsFileInsertionScanDataContainer.this.close();
                    }
                }
            }
        };
    }

    private Tablet getNextTablet() {
        try {
            Tablet tablet = null;
            if (!this.data.hasCurrent()) {
                tablet = new Tablet(this.currentDevice, this.currentMeasurements, 1);
                tablet.initBitMaps();
                PipeDataNodeResourceManager.memory().forceResize(this.allocatedMemoryBlockForTablet, 0L);
                return tablet;
            }
            boolean isFirstRow = true;
            while (this.data.hasCurrent()) {
                if (this.currentIsMultiPage || this.data.currentTime() >= this.startTime && this.data.currentTime() <= this.endTime) {
                    int rowIndex;
                    if (isFirstRow) {
                        Pair<Integer, Integer> rowCountAndMemorySize = PipeMemoryWeightUtil.calculateTabletRowCountAndMemory(this.data);
                        tablet = new Tablet(this.currentDevice, this.currentMeasurements, ((Integer)rowCountAndMemorySize.getLeft()).intValue());
                        tablet.initBitMaps();
                        if (this.allocatedMemoryBlockForTablet.getMemoryUsageInBytes() < (long)((Integer)rowCountAndMemorySize.getRight()).intValue()) {
                            PipeDataNodeResourceManager.memory().forceResize(this.allocatedMemoryBlockForTablet, ((Integer)rowCountAndMemorySize.getRight()).intValue());
                        }
                        isFirstRow = false;
                    }
                    if (this.putValueToColumns(this.data, tablet, rowIndex = tablet.rowSize)) {
                        tablet.addTimestamp(rowIndex, this.data.currentTime());
                    }
                    ++tablet.rowSize;
                }
                this.data.next();
                while (!this.data.hasCurrent() && this.chunkReader.hasNextSatisfiedPage()) {
                    this.data = this.chunkReader.nextPageData();
                }
                if (tablet == null || tablet.rowSize != tablet.getMaxRowNumber()) continue;
            }
            if (tablet == null) {
                tablet = new Tablet(this.currentDevice, this.currentMeasurements, 1);
                tablet.initBitMaps();
            }
            if (!this.data.hasCurrent()) {
                this.prepareData();
            }
            return tablet;
        }
        catch (Exception e) {
            this.close();
            throw new PipeException("Failed to get next tablet insertion event.", (Throwable)e);
        }
    }

    private void prepareData() throws IOException {
        while (true) {
            this.moveToNextChunkReader();
            if (Objects.nonNull(this.chunkReader) && !this.chunkReader.hasNextSatisfiedPage()) continue;
            if (Objects.isNull(this.chunkReader)) {
                this.close();
                break;
            }
            do {
                this.data = this.chunkReader.nextPageData();
                long size = PipeMemoryWeightUtil.calculateBatchDataRamBytesUsed(this.data);
                if (this.allocatedMemoryBlockForBatchData.getMemoryUsageInBytes() >= size) continue;
                PipeDataNodeResourceManager.memory().forceResize(this.allocatedMemoryBlockForBatchData, size);
            } while (!this.data.hasCurrent() && this.chunkReader.hasNextSatisfiedPage());
            if (this.data.hasCurrent()) break;
        }
    }

    private boolean putValueToColumns(BatchData data, Tablet tablet, int rowIndex) {
        Object[] columns = tablet.values;
        boolean isNeedFillTime = false;
        if (data.getDataType() == TSDataType.VECTOR) {
            block18: for (int i = 0; i < columns.length; ++i) {
                TsPrimitiveType primitiveType = data.getVector()[i];
                if (Objects.isNull(primitiveType) || ModsOperationUtil.isDelete(data.currentTime(), this.modsInfos.get(i))) {
                    tablet.bitMaps[i].mark(rowIndex);
                    TSDataType type = ((MeasurementSchema)tablet.getSchemas().get(i)).getType();
                    if (type == TSDataType.TEXT || type == TSDataType.BLOB || type == TSDataType.STRING) {
                        ((Binary[])columns[i])[rowIndex] = Binary.EMPTY_VALUE;
                    }
                    if (type != TSDataType.DATE) continue;
                    ((LocalDate[])columns[i])[rowIndex] = EMPTY_DATE;
                    continue;
                }
                isNeedFillTime = true;
                switch (((MeasurementSchema)tablet.getSchemas().get(i)).getType()) {
                    case BOOLEAN: {
                        ((boolean[])columns[i])[rowIndex] = primitiveType.getBoolean();
                        continue block18;
                    }
                    case INT32: {
                        ((int[])columns[i])[rowIndex] = primitiveType.getInt();
                        continue block18;
                    }
                    case DATE: {
                        ((LocalDate[])columns[i])[rowIndex] = DateUtils.parseIntToLocalDate((int)primitiveType.getInt());
                        continue block18;
                    }
                    case INT64: 
                    case TIMESTAMP: {
                        ((long[])columns[i])[rowIndex] = primitiveType.getLong();
                        continue block18;
                    }
                    case FLOAT: {
                        ((float[])columns[i])[rowIndex] = primitiveType.getFloat();
                        continue block18;
                    }
                    case DOUBLE: {
                        ((double[])columns[i])[rowIndex] = primitiveType.getDouble();
                        continue block18;
                    }
                    case TEXT: 
                    case BLOB: 
                    case STRING: {
                        ((Binary[])columns[i])[rowIndex] = primitiveType.getBinary();
                        continue block18;
                    }
                    default: {
                        throw new UnSupportedDataTypeException("UnSupported" + primitiveType.getDataType());
                    }
                }
            }
        } else {
            isNeedFillTime = true;
            switch (((MeasurementSchema)tablet.getSchemas().get(0)).getType()) {
                case BOOLEAN: {
                    ((boolean[])columns[0])[rowIndex] = data.getBoolean();
                    break;
                }
                case INT32: {
                    ((int[])columns[0])[rowIndex] = data.getInt();
                    break;
                }
                case DATE: {
                    ((LocalDate[])columns[0])[rowIndex] = DateUtils.parseIntToLocalDate((int)data.getInt());
                    break;
                }
                case INT64: 
                case TIMESTAMP: {
                    ((long[])columns[0])[rowIndex] = data.getLong();
                    break;
                }
                case FLOAT: {
                    ((float[])columns[0])[rowIndex] = data.getFloat();
                    break;
                }
                case DOUBLE: {
                    ((double[])columns[0])[rowIndex] = data.getDouble();
                    break;
                }
                case TEXT: 
                case BLOB: 
                case STRING: {
                    ((Binary[])columns[0])[rowIndex] = data.getBinary();
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException("UnSupported" + data.getDataType());
                }
            }
        }
        return isNeedFillTime;
    }

    private void moveToNextChunkReader() throws IOException, IllegalStateException {
        byte marker;
        long valueChunkSize = 0L;
        ArrayList<Chunk> valueChunkList = new ArrayList<Chunk>();
        this.currentMeasurements.clear();
        this.modsInfos.clear();
        if (this.lastMarker == 2) {
            this.chunkReader = null;
            return;
        }
        block10: while ((marker = this.lastMarker != -128 ? this.lastMarker : this.tsFileSequenceReader.readMarker()) != 2) {
            this.lastMarker = (byte)-128;
            switch (marker) {
                case -127: 
                case -123: 
                case 1: 
                case 5: {
                    this.currentIsMultiPage = marker == 1;
                    long currentChunkHeaderOffset = this.tsFileSequenceReader.position() - 1L;
                    ChunkHeader chunkHeader = this.tsFileSequenceReader.readChunkHeader(marker);
                    long nextMarkerOffset = this.tsFileSequenceReader.position() + (long)chunkHeader.getDataSize();
                    if (Objects.isNull(this.currentDevice)) {
                        this.tsFileSequenceReader.position(nextMarkerOffset);
                        continue block10;
                    }
                    if ((chunkHeader.getChunkType() & 0xFFFFFF80) == -128) {
                        this.timeChunkList.add(new Chunk(chunkHeader, this.tsFileSequenceReader.readChunk(-1L, chunkHeader.getDataSize())));
                        this.isMultiPageList.add(marker == -127);
                        continue block10;
                    }
                    if (!this.pattern.matchesMeasurement(this.currentDevice, chunkHeader.getMeasurementID())) {
                        this.tsFileSequenceReader.position(nextMarkerOffset);
                        continue block10;
                    }
                    if (!this.currentModifications.isEmpty()) {
                        Statistics statistics = null;
                        try {
                            statistics = this.findNonAlignedChunkStatistics(this.tsFileSequenceReader.getIChunkMetadataList((Path)CompactionPathUtils.getPath(this.currentDevice, chunkHeader.getMeasurementID())), currentChunkHeaderOffset);
                        }
                        catch (IllegalPathException ignore) {
                            LOGGER.warn("Failed to get chunk metadata for {}.{}", (Object)this.currentDevice, (Object)chunkHeader.getMeasurementID());
                        }
                        if (statistics != null && ModsOperationUtil.isAllDeletedByMods(this.currentDevice, chunkHeader.getMeasurementID(), statistics.getStartTime(), statistics.getEndTime(), (PatternTreeMap<Modification, PatternTreeMapFactory.ModsSerializer>)this.currentModifications)) {
                            this.tsFileSequenceReader.position(nextMarkerOffset);
                            continue block10;
                        }
                    }
                    if ((long)chunkHeader.getDataSize() > this.allocatedMemoryBlockForChunk.getMemoryUsageInBytes()) {
                        PipeDataNodeResourceManager.memory().forceResize(this.allocatedMemoryBlockForChunk, chunkHeader.getDataSize());
                    }
                    Chunk chunk = new Chunk(chunkHeader, this.tsFileSequenceReader.readChunk(-1L, chunkHeader.getDataSize()));
                    this.chunkReader = this.currentIsMultiPage ? new ChunkReader(chunk, this.filter) : new SinglePageWholeChunkReader(chunk);
                    this.currentIsAligned = false;
                    this.currentMeasurements.add(new MeasurementSchema(chunkHeader.getMeasurementID(), chunkHeader.getDataType()));
                    this.modsInfos.addAll(ModsOperationUtil.initializeMeasurementMods(this.currentDevice, Collections.singletonList(chunkHeader.getMeasurementID()), (PatternTreeMap<Modification, PatternTreeMapFactory.ModsSerializer>)this.currentModifications));
                    return;
                }
                case 65: 
                case 69: {
                    long nextMarkerOffset;
                    ChunkHeader chunkHeader;
                    if (Objects.isNull(this.firstChunkHeader4NextSequentialValueChunks)) {
                        long timeChunkSize;
                        long currentChunkHeaderOffset = this.tsFileSequenceReader.position() - 1L;
                        chunkHeader = this.tsFileSequenceReader.readChunkHeader(marker);
                        nextMarkerOffset = this.tsFileSequenceReader.position() + (long)chunkHeader.getDataSize();
                        if (Objects.isNull(this.currentDevice) || !this.pattern.matchesMeasurement(this.currentDevice, chunkHeader.getMeasurementID())) {
                            this.tsFileSequenceReader.position(nextMarkerOffset);
                            continue block10;
                        }
                        if (!this.currentModifications.isEmpty()) {
                            Statistics statistics = null;
                            try {
                                statistics = this.findAlignedChunkStatistics(this.tsFileSequenceReader.getIChunkMetadataList((Path)CompactionPathUtils.getPath(this.currentDevice, chunkHeader.getMeasurementID())), currentChunkHeaderOffset);
                            }
                            catch (IllegalPathException ignore) {
                                LOGGER.warn("Failed to get chunk metadata for {}.{}", (Object)this.currentDevice, (Object)chunkHeader.getMeasurementID());
                            }
                            if (statistics != null && ModsOperationUtil.isAllDeletedByMods(this.currentDevice, chunkHeader.getMeasurementID(), statistics.getStartTime(), statistics.getEndTime(), (PatternTreeMap<Modification, PatternTreeMapFactory.ModsSerializer>)this.currentModifications)) {
                                this.tsFileSequenceReader.position(nextMarkerOffset);
                                continue block10;
                            }
                        }
                        int valueIndex = this.measurementIndexMap.compute(chunkHeader.getMeasurementID(), (measurement, index) -> Objects.nonNull(index) ? index + 1 : 0);
                        if (chunkHeader.getDataSize() == 0) continue block10;
                        boolean needReturn = false;
                        long l = timeChunkSize = this.lastIndex >= 0 ? PipeMemoryWeightUtil.calculateChunkRamBytesUsed(this.timeChunkList.get(this.lastIndex)) : 0L;
                        if (this.lastIndex >= 0) {
                            if (valueIndex != this.lastIndex) {
                                needReturn = this.recordAlignedChunk(valueChunkList, marker);
                            } else {
                                long chunkSize = timeChunkSize + valueChunkSize;
                                if (chunkSize + (long)chunkHeader.getDataSize() > this.allocatedMemoryBlockForChunk.getMemoryUsageInBytes()) {
                                    if (valueChunkList.size() == 1 && chunkSize > this.allocatedMemoryBlockForChunk.getMemoryUsageInBytes()) {
                                        PipeDataNodeResourceManager.memory().forceResize(this.allocatedMemoryBlockForChunk, chunkSize);
                                    }
                                    needReturn = this.recordAlignedChunk(valueChunkList, marker);
                                }
                            }
                        }
                        this.lastIndex = valueIndex;
                        if (needReturn) {
                            this.firstChunkHeader4NextSequentialValueChunks = chunkHeader;
                            return;
                        }
                    } else {
                        chunkHeader = this.firstChunkHeader4NextSequentialValueChunks;
                        this.firstChunkHeader4NextSequentialValueChunks = null;
                    }
                    Chunk chunk = new Chunk(chunkHeader, this.tsFileSequenceReader.readChunk(-1L, chunkHeader.getDataSize()));
                    valueChunkSize += (long)chunkHeader.getDataSize();
                    valueChunkList.add(chunk);
                    this.currentMeasurements.add(new MeasurementSchema(chunkHeader.getMeasurementID(), chunkHeader.getDataType()));
                    this.modsInfos.addAll(ModsOperationUtil.initializeMeasurementMods(this.currentDevice, Collections.singletonList(chunkHeader.getMeasurementID()), (PatternTreeMap<Modification, PatternTreeMapFactory.ModsSerializer>)this.currentModifications));
                    continue block10;
                }
                case 0: {
                    if (this.recordAlignedChunk(valueChunkList, marker)) {
                        return;
                    }
                    String deviceID = ((PlainDeviceID)this.tsFileSequenceReader.readChunkGroupHeader().getDeviceID()).toStringID();
                    this.lastIndex = -1;
                    this.timeChunkList.clear();
                    this.isMultiPageList.clear();
                    this.measurementIndexMap.clear();
                    this.currentDevice = this.pattern.mayOverlapWithDevice(deviceID) ? deviceID : null;
                    continue block10;
                }
                case 4: {
                    this.tsFileSequenceReader.readPlanIndex();
                    continue block10;
                }
            }
            MetaMarker.handleUnexpectedMarker((byte)marker);
        }
        this.lastMarker = marker;
        if (!this.recordAlignedChunk(valueChunkList, marker)) {
            this.chunkReader = null;
        }
    }

    private boolean recordAlignedChunk(List<Chunk> valueChunkList, byte marker) throws IOException {
        if (!valueChunkList.isEmpty()) {
            Chunk timeChunk = this.timeChunkList.get(this.lastIndex);
            timeChunk.getData().rewind();
            this.currentIsMultiPage = this.isMultiPageList.get(this.lastIndex);
            this.chunkReader = this.currentIsMultiPage ? new AlignedChunkReader(timeChunk, valueChunkList, this.filter) : new AlignedSinglePageWholeChunkReader(timeChunk, valueChunkList);
            this.currentIsAligned = true;
            this.lastMarker = marker;
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        super.close();
        if (this.allocatedMemoryBlockForBatchData != null) {
            this.allocatedMemoryBlockForBatchData.close();
        }
        if (this.allocatedMemoryBlockForChunk != null) {
            this.allocatedMemoryBlockForChunk.close();
        }
    }

    private Statistics findAlignedChunkStatistics(List<IChunkMetadata> metadataList, long currentChunkHeaderOffset) {
        for (IChunkMetadata metadata : metadataList) {
            if (!(metadata instanceof AlignedChunkMetadata)) continue;
            List list = ((AlignedChunkMetadata)metadata).getValueChunkMetadataList();
            for (IChunkMetadata m : list) {
                if (m.getOffsetOfChunkHeader() != currentChunkHeaderOffset) continue;
                return m.getStatistics();
            }
        }
        return null;
    }

    private Statistics findNonAlignedChunkStatistics(List<IChunkMetadata> metadataList, long currentChunkHeaderOffset) {
        for (IChunkMetadata metadata : metadataList) {
            if (metadata.getOffsetOfChunkHeader() != currentChunkHeaderOffset) continue;
            return metadata.getStatistics();
        }
        return null;
    }
}

