/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ddl.CreateOperation;

public class CreateDatabaseOperation
implements CreateOperation {
    private final String catalogName;
    private final String databaseName;
    private final CatalogDatabase catalogDatabase;
    private final boolean ignoreIfExists;

    public CreateDatabaseOperation(String catalogName, String databaseName, CatalogDatabase catalogDatabase, boolean ignoreIfExists) {
        this.catalogName = catalogName;
        this.databaseName = databaseName;
        this.catalogDatabase = catalogDatabase;
        this.ignoreIfExists = ignoreIfExists;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public CatalogDatabase getCatalogDatabase() {
        return this.catalogDatabase;
    }

    public boolean isIgnoreIfExists() {
        return this.ignoreIfExists;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("catalogDatabase", this.catalogDatabase.getProperties());
        params.put("catalogName", this.catalogName);
        params.put("databaseName", this.databaseName);
        params.put("ignoreIfExists", this.ignoreIfExists);
        return OperationUtils.formatWithChildren("CREATE DATABASE", params, Collections.emptyList(), Operation::asSummaryString);
    }
}

