/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogFunctionImpl;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.ContextResolvedFunction;
import org.apache.flink.table.catalog.FunctionLanguage;
import org.apache.flink.table.catalog.FunctionLookup;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.TemporaryOperationListener;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.FunctionNotExistException;
import org.apache.flink.table.delegation.PlannerTypeInferenceUtil;
import org.apache.flink.table.factories.FunctionDefinitionFactory;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.AggregateFunctionDefinition;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.functions.ImperativeAggregateFunction;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.ScalarFunctionDefinition;
import org.apache.flink.table.functions.TableAggregateFunction;
import org.apache.flink.table.functions.TableAggregateFunctionDefinition;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.TableFunctionDefinition;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.functions.UserDefinedFunctionHelper;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.util.Preconditions;

@Internal
public final class FunctionCatalog {
    private final ReadableConfig config;
    private final CatalogManager catalogManager;
    private final ModuleManager moduleManager;
    private final Map<String, CatalogFunction> tempSystemFunctions = new LinkedHashMap<String, CatalogFunction>();
    private final Map<ObjectIdentifier, CatalogFunction> tempCatalogFunctions = new LinkedHashMap<ObjectIdentifier, CatalogFunction>();
    private PlannerTypeInferenceUtil plannerTypeInferenceUtil;

    public FunctionCatalog(ReadableConfig config, CatalogManager catalogManager, ModuleManager moduleManager) {
        this.config = (ReadableConfig)Preconditions.checkNotNull((Object)config);
        this.catalogManager = (CatalogManager)Preconditions.checkNotNull((Object)catalogManager);
        this.moduleManager = (ModuleManager)Preconditions.checkNotNull((Object)moduleManager);
    }

    public void setPlannerTypeInferenceUtil(PlannerTypeInferenceUtil plannerTypeInferenceUtil) {
        this.plannerTypeInferenceUtil = plannerTypeInferenceUtil;
    }

    public void registerTemporarySystemFunction(String name, FunctionDefinition definition, boolean ignoreIfExists) {
        this.registerTemporarySystemFunction(name, new InlineCatalogFunction(definition), ignoreIfExists);
    }

    public void registerTemporarySystemFunction(String name, String fullyQualifiedName, FunctionLanguage language, boolean ignoreIfExists) {
        this.registerTemporarySystemFunction(name, new CatalogFunctionImpl(fullyQualifiedName, language), ignoreIfExists);
    }

    public boolean dropTemporarySystemFunction(String name, boolean ignoreIfNotExist) {
        String normalizedName = FunctionIdentifier.normalizeName((String)name);
        CatalogFunction function = this.tempSystemFunctions.remove(normalizedName);
        if (function == null && !ignoreIfNotExist) {
            throw new ValidationException(String.format("Could not drop temporary system function. A function named '%s' doesn't exist.", name));
        }
        return function != null;
    }

    public void registerTemporaryCatalogFunction(UnresolvedIdentifier unresolvedIdentifier, FunctionDefinition definition, boolean ignoreIfExists) {
        this.registerTemporaryCatalogFunction(unresolvedIdentifier, new InlineCatalogFunction(definition), ignoreIfExists);
    }

    public void registerTemporaryCatalogFunction(UnresolvedIdentifier unresolvedIdentifier, CatalogFunction catalogFunction, boolean ignoreIfExists) {
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        ObjectIdentifier normalizedIdentifier = FunctionIdentifier.normalizeObjectIdentifier((ObjectIdentifier)identifier);
        if (!this.tempCatalogFunctions.containsKey(normalizedIdentifier)) {
            Optional<TemporaryOperationListener> listener = this.catalogManager.getTemporaryOperationListener(normalizedIdentifier);
            if (listener.isPresent()) {
                catalogFunction = listener.get().onCreateTemporaryFunction(normalizedIdentifier.toObjectPath(), catalogFunction);
            }
            try {
                this.validateAndPrepareFunction(catalogFunction);
            }
            catch (Throwable t) {
                throw new ValidationException(String.format("Could not register temporary catalog function '%s' due to implementation errors.", identifier.asSummaryString()), t);
            }
            this.tempCatalogFunctions.put(normalizedIdentifier, catalogFunction);
        } else if (!ignoreIfExists) {
            throw new ValidationException(String.format("Could not register temporary catalog function. A function '%s' does already exist.", identifier.asSummaryString()));
        }
    }

    public boolean dropTemporaryCatalogFunction(UnresolvedIdentifier unresolvedIdentifier, boolean ignoreIfNotExist) {
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        return this.dropTempCatalogFunction(identifier, ignoreIfNotExist) != null;
    }

    public void registerCatalogFunction(UnresolvedIdentifier unresolvedIdentifier, Class<? extends UserDefinedFunction> functionClass, boolean ignoreIfExists) {
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        ObjectIdentifier normalizedIdentifier = FunctionIdentifier.normalizeObjectIdentifier((ObjectIdentifier)identifier);
        try {
            UserDefinedFunctionHelper.validateClass(functionClass);
        }
        catch (Throwable t) {
            throw new ValidationException(String.format("Could not register catalog function '%s' due to implementation errors.", identifier.asSummaryString()), t);
        }
        Catalog catalog = this.catalogManager.getCatalog(normalizedIdentifier.getCatalogName()).orElseThrow(IllegalStateException::new);
        ObjectPath path = identifier.toObjectPath();
        if (this.tempCatalogFunctions.containsKey(normalizedIdentifier)) {
            if (ignoreIfExists) {
                return;
            }
            throw new ValidationException(String.format("Could not register catalog function. A temporary function '%s' does already exist. Please drop the temporary function first.", identifier.asSummaryString()));
        }
        if (catalog.functionExists(path)) {
            if (ignoreIfExists) {
                return;
            }
            throw new ValidationException(String.format("Could not register catalog function. A function '%s' does already exist.", identifier.asSummaryString()));
        }
        CatalogFunctionImpl catalogFunction = new CatalogFunctionImpl(functionClass.getName(), FunctionLanguage.JAVA);
        try {
            catalog.createFunction(path, (CatalogFunction)catalogFunction, ignoreIfExists);
        }
        catch (Throwable t) {
            throw new TableException(String.format("Could not register catalog function '%s'.", identifier.asSummaryString()), t);
        }
    }

    public boolean dropCatalogFunction(UnresolvedIdentifier unresolvedIdentifier, boolean ignoreIfNotExist) {
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        ObjectIdentifier normalizedIdentifier = FunctionIdentifier.normalizeObjectIdentifier((ObjectIdentifier)identifier);
        Catalog catalog = this.catalogManager.getCatalog(normalizedIdentifier.getCatalogName()).orElseThrow(IllegalStateException::new);
        ObjectPath path = identifier.toObjectPath();
        if (this.tempCatalogFunctions.containsKey(normalizedIdentifier)) {
            throw new ValidationException(String.format("Could not drop catalog function. A temporary function '%s' does already exist. Please drop the temporary function first.", identifier.asSummaryString()));
        }
        if (!catalog.functionExists(path)) {
            if (ignoreIfNotExist) {
                return false;
            }
            throw new ValidationException(String.format("Could not drop catalog function. A function '%s' doesn't exist.", identifier.asSummaryString()));
        }
        try {
            catalog.dropFunction(path, ignoreIfNotExist);
        }
        catch (Throwable t) {
            throw new TableException(String.format("Could not drop catalog function '%s'.", identifier.asSummaryString()), t);
        }
        return true;
    }

    public String[] getUserDefinedFunctions() {
        return this.getUserDefinedFunctionNames().toArray(new String[0]);
    }

    public String[] getFunctions() {
        Set<String> result = this.getUserDefinedFunctionNames();
        result.addAll(this.moduleManager.listFunctions());
        return result.toArray(new String[0]);
    }

    public boolean hasTemporaryCatalogFunction(ObjectIdentifier functionIdentifier) {
        ObjectIdentifier normalizedIdentifier = FunctionIdentifier.normalizeObjectIdentifier((ObjectIdentifier)functionIdentifier);
        return this.tempCatalogFunctions.containsKey(normalizedIdentifier);
    }

    public boolean hasTemporarySystemFunction(String functionName) {
        return this.tempSystemFunctions.containsKey(functionName);
    }

    public FunctionLookup asLookup(final Function<String, UnresolvedIdentifier> parser) {
        return new FunctionLookup(){

            @Override
            public Optional<ContextResolvedFunction> lookupFunction(String stringIdentifier) {
                UnresolvedIdentifier unresolvedIdentifier = (UnresolvedIdentifier)parser.apply(stringIdentifier);
                return this.lookupFunction(unresolvedIdentifier);
            }

            @Override
            public Optional<ContextResolvedFunction> lookupFunction(UnresolvedIdentifier identifier) {
                return FunctionCatalog.this.lookupFunction(identifier);
            }

            @Override
            public PlannerTypeInferenceUtil getPlannerTypeInferenceUtil() {
                Preconditions.checkNotNull((Object)FunctionCatalog.this.plannerTypeInferenceUtil, (String)"A planner should have set the type inference utility.");
                return FunctionCatalog.this.plannerTypeInferenceUtil;
            }
        };
    }

    public Optional<ContextResolvedFunction> lookupFunction(UnresolvedIdentifier identifier) {
        if (identifier.getDatabaseName().isPresent()) {
            return this.resolvePreciseFunctionReference(this.catalogManager.qualifyIdentifier(identifier));
        }
        return this.resolveAmbiguousFunctionReference(identifier.getObjectName());
    }

    @Deprecated
    public void registerTempSystemScalarFunction(String name, ScalarFunction function) {
        UserDefinedFunctionHelper.prepareInstance((ReadableConfig)this.config, (UserDefinedFunction)function);
        this.registerTempSystemFunction(name, (FunctionDefinition)new ScalarFunctionDefinition(name, function));
    }

    @Deprecated
    public <T> void registerTempSystemTableFunction(String name, TableFunction<T> function, TypeInformation<T> resultType) {
        UserDefinedFunctionHelper.prepareInstance((ReadableConfig)this.config, function);
        this.registerTempSystemFunction(name, (FunctionDefinition)new TableFunctionDefinition(name, function, resultType));
    }

    @Deprecated
    public <T, ACC> void registerTempSystemAggregateFunction(String name, ImperativeAggregateFunction<T, ACC> function, TypeInformation<T> resultType, TypeInformation<ACC> accType) {
        AggregateFunctionDefinition definition;
        UserDefinedFunctionHelper.prepareInstance((ReadableConfig)this.config, function);
        if (function instanceof AggregateFunction) {
            definition = new AggregateFunctionDefinition(name, (AggregateFunction)function, resultType, accType);
        } else if (function instanceof TableAggregateFunction) {
            definition = new TableAggregateFunctionDefinition(name, (TableAggregateFunction)function, resultType, accType);
        } else {
            throw new TableException("Unknown function class: " + function.getClass());
        }
        this.registerTempSystemFunction(name, (FunctionDefinition)definition);
    }

    @Deprecated
    public void registerTempCatalogScalarFunction(ObjectIdentifier oi, ScalarFunction function) {
        UserDefinedFunctionHelper.prepareInstance((ReadableConfig)this.config, (UserDefinedFunction)function);
        this.registerTempCatalogFunction(oi, (FunctionDefinition)new ScalarFunctionDefinition(oi.getObjectName(), function));
    }

    public CatalogFunction dropTempCatalogFunction(ObjectIdentifier identifier, boolean ignoreIfNotExist) {
        ObjectIdentifier normalizedName = FunctionIdentifier.normalizeObjectIdentifier((ObjectIdentifier)identifier);
        CatalogFunction fd = this.tempCatalogFunctions.get(normalizedName);
        if (fd != null) {
            this.catalogManager.getTemporaryOperationListener(normalizedName).ifPresent(l -> l.onDropTemporaryFunction(normalizedName.toObjectPath()));
            this.tempCatalogFunctions.remove(normalizedName);
        } else if (!ignoreIfNotExist) {
            throw new ValidationException(String.format("Temporary catalog function %s doesn't exist", identifier));
        }
        return fd;
    }

    @Deprecated
    private void registerTempSystemFunction(String name, FunctionDefinition functionDefinition) {
        this.tempSystemFunctions.put(FunctionIdentifier.normalizeName((String)name), new InlineCatalogFunction(functionDefinition));
    }

    @Deprecated
    private void registerTempCatalogFunction(ObjectIdentifier oi, FunctionDefinition functionDefinition) {
        this.tempCatalogFunctions.put(FunctionIdentifier.normalizeObjectIdentifier((ObjectIdentifier)oi), new InlineCatalogFunction(functionDefinition));
    }

    public void registerTemporarySystemFunction(String name, CatalogFunction function, boolean ignoreIfExists) {
        String normalizedName = FunctionIdentifier.normalizeName((String)name);
        try {
            this.validateAndPrepareFunction(function);
        }
        catch (Throwable t) {
            throw new ValidationException(String.format("Could not register temporary system function '%s' due to implementation errors.", name), t);
        }
        if (!this.tempSystemFunctions.containsKey(normalizedName)) {
            this.tempSystemFunctions.put(normalizedName, function);
        } else if (!ignoreIfExists) {
            throw new ValidationException(String.format("Could not register temporary system function. A function named '%s' does already exist.", name));
        }
    }

    private Set<String> getUserDefinedFunctionNames() {
        HashSet<String> result = new HashSet<String>(this.tempSystemFunctions.keySet());
        String currentCatalog = this.catalogManager.getCurrentCatalog();
        String currentDatabase = this.catalogManager.getCurrentDatabase();
        result.addAll(this.tempCatalogFunctions.keySet().stream().filter(oi -> oi.getCatalogName().equals(currentCatalog) && oi.getDatabaseName().equals(currentDatabase)).map(ObjectIdentifier::getObjectName).collect(Collectors.toSet()));
        Catalog catalog = this.catalogManager.getCatalog(currentCatalog).get();
        try {
            result.addAll(catalog.listFunctions(currentDatabase));
        }
        catch (DatabaseNotExistException databaseNotExistException) {
            // empty catch block
        }
        return result;
    }

    private Optional<ContextResolvedFunction> resolvePreciseFunctionReference(ObjectIdentifier oi) {
        ObjectIdentifier normalizedIdentifier = FunctionIdentifier.normalizeObjectIdentifier((ObjectIdentifier)oi);
        CatalogFunction potentialResult = this.tempCatalogFunctions.get(normalizedIdentifier);
        if (potentialResult != null) {
            return Optional.of(ContextResolvedFunction.temporary(FunctionIdentifier.of((ObjectIdentifier)oi), this.getFunctionDefinition(oi.getObjectName(), potentialResult)));
        }
        Optional<Catalog> catalogOptional = this.catalogManager.getCatalog(oi.getCatalogName());
        if (catalogOptional.isPresent()) {
            Catalog catalog = catalogOptional.get();
            try {
                CatalogFunction catalogFunction = catalog.getFunction(new ObjectPath(oi.getDatabaseName(), oi.getObjectName()));
                FunctionDefinition fd = catalog.getFunctionDefinitionFactory().isPresent() && catalogFunction.getFunctionLanguage() != FunctionLanguage.PYTHON ? ((FunctionDefinitionFactory)catalog.getFunctionDefinitionFactory().get()).createFunctionDefinition(oi.getObjectName(), catalogFunction) : this.getFunctionDefinition(oi.asSummaryString(), catalogFunction);
                return Optional.of(ContextResolvedFunction.permanent(FunctionIdentifier.of((ObjectIdentifier)oi), fd));
            }
            catch (FunctionNotExistException functionNotExistException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    private Optional<ContextResolvedFunction> resolveAmbiguousFunctionReference(String funcName) {
        String normalizedName = FunctionIdentifier.normalizeName((String)funcName);
        if (this.tempSystemFunctions.containsKey(normalizedName)) {
            return Optional.of(ContextResolvedFunction.temporary(FunctionIdentifier.of((String)funcName), this.getFunctionDefinition(normalizedName, this.tempSystemFunctions.get(normalizedName))));
        }
        Optional<FunctionDefinition> candidate = this.moduleManager.getFunctionDefinition(normalizedName);
        ObjectIdentifier oi = ObjectIdentifier.of((String)this.catalogManager.getCurrentCatalog(), (String)this.catalogManager.getCurrentDatabase(), (String)funcName);
        return candidate.map(fd -> Optional.of(ContextResolvedFunction.permanent(FunctionIdentifier.of((String)funcName), fd))).orElseGet(() -> this.resolvePreciseFunctionReference(oi));
    }

    private void validateAndPrepareFunction(CatalogFunction function) throws ClassNotFoundException {
        if (function instanceof InlineCatalogFunction) {
            FunctionDefinition definition = ((InlineCatalogFunction)function).getDefinition();
            if (definition instanceof UserDefinedFunction) {
                UserDefinedFunctionHelper.prepareInstance((ReadableConfig)this.config, (UserDefinedFunction)((UserDefinedFunction)definition));
            }
        } else if (function.getFunctionLanguage() == FunctionLanguage.JAVA) {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            UserDefinedFunctionHelper.validateClass(contextClassLoader.loadClass(function.getClassName()));
        }
    }

    private FunctionDefinition getFunctionDefinition(String name, CatalogFunction function) {
        if (function instanceof InlineCatalogFunction) {
            return ((InlineCatalogFunction)function).getDefinition();
        }
        return UserDefinedFunctionHelper.instantiateFunction((ClassLoader)Thread.currentThread().getContextClassLoader(), (ReadableConfig)this.config, (String)name, (CatalogFunction)function);
    }

    public static class InlineCatalogFunction
    implements CatalogFunction {
        private final FunctionDefinition definition;

        public InlineCatalogFunction(FunctionDefinition definition) {
            this.definition = definition;
        }

        public String getClassName() {
            throw new UnsupportedOperationException("This CatalogFunction is a InlineCatalogFunction. This method should not be called.");
        }

        public CatalogFunction copy() {
            return new InlineCatalogFunction(this.definition);
        }

        public Optional<String> getDescription() {
            return Optional.empty();
        }

        public Optional<String> getDetailedDescription() {
            return Optional.empty();
        }

        public boolean isGeneric() {
            throw new UnsupportedOperationException("This CatalogFunction is a InlineCatalogFunction. This method should not be called.");
        }

        public FunctionLanguage getFunctionLanguage() {
            return FunctionLanguage.JAVA;
        }

        public FunctionDefinition getDefinition() {
            return this.definition;
        }
    }
}

