/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.service.sink;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.inlong.audit.service.channel.DataQueue;
import org.apache.inlong.audit.service.config.Configuration;
import org.apache.inlong.audit.service.entities.SinkConfig;
import org.apache.inlong.audit.service.entities.StatData;
import org.apache.inlong.audit.service.sink.AuditSink;
import org.apache.inlong.audit.service.utils.JdbcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcSink
implements AutoCloseable,
AuditSink {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcSink.class);
    private final ScheduledExecutorService sinkTimer = Executors.newSingleThreadScheduledExecutor();
    private final DataQueue dataQueue;
    private final int insertBatch;
    private final int pullTimeOut;
    private final SinkConfig sinkConfig;
    private DataSource dataSource;
    private final Configuration configuration = Configuration.getInstance();

    public JdbcSink(DataQueue dataQueue, SinkConfig sinkConfig) {
        this.dataQueue = dataQueue;
        this.sinkConfig = sinkConfig;
        this.insertBatch = this.configuration.get("sink.db.batch", 1000);
        this.pullTimeOut = this.configuration.get("queue.pull.timeout.ms", 1000);
    }

    public void start() {
        this.createDataSource();
        this.sinkTimer.scheduleWithFixedDelay(() -> this.process(), 0L, this.configuration.get("sink.db.interval.ms", 100), TimeUnit.MILLISECONDS);
    }

    private void process() {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.sinkConfig.getInsertSql());){
            if (connection.isClosed()) {
                this.createDataSource();
            }
            int counter = 0;
            StatData data = this.dataQueue.pull((long)this.pullTimeOut, TimeUnit.MILLISECONDS);
            while (data != null) {
                preparedStatement.setString(1, data.getLogTs());
                preparedStatement.setString(2, data.getInlongGroupId());
                preparedStatement.setString(3, data.getInlongStreamId());
                preparedStatement.setString(4, data.getAuditId());
                preparedStatement.setString(5, data.getAuditTag());
                preparedStatement.setLong(6, data.getCount());
                preparedStatement.setLong(7, data.getSize());
                preparedStatement.setLong(8, data.getDelay());
                preparedStatement.addBatch();
                if (++counter >= this.insertBatch) {
                    preparedStatement.executeBatch();
                    preparedStatement.clearBatch();
                    counter = 0;
                }
                data = this.dataQueue.pull((long)this.pullTimeOut, TimeUnit.MILLISECONDS);
            }
            if (counter > 0) {
                preparedStatement.executeBatch();
                preparedStatement.clearBatch();
            }
        }
        catch (Exception exception) {
            LOGGER.error("Process exception!", (Throwable)exception);
        }
    }

    protected void createDataSource() {
        HikariConfig hikariConfig = JdbcUtils.buildHikariConfig((String)this.sinkConfig.getDriverClassName(), (String)this.sinkConfig.getJdbcUrl(), (String)this.sinkConfig.getUserName(), (String)this.sinkConfig.getPassword());
        this.dataSource = new HikariDataSource(hikariConfig);
    }

    public void destroy() {
        this.sinkTimer.shutdown();
    }

    @Override
    public void close() {
    }
}

