/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.transformation.function;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.sort.protocol.transformation.ConstantParam;
import org.apache.inlong.sort.protocol.transformation.Function;
import org.apache.inlong.sort.protocol.transformation.FunctionParam;

@JsonTypeName(value="cast")
public class CastFunction
implements Function {
    @JsonProperty(value="field")
    private FunctionParam field;
    private String type;

    @JsonCreator
    public CastFunction(@JsonProperty(value="field") FunctionParam field, @JsonProperty(value="type") String type) {
        this.field = (FunctionParam)Preconditions.checkNotNull((Object)field, (Object)"field is null");
        this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"type is null");
    }

    @Override
    public List<FunctionParam> getParams() {
        return Arrays.asList(this.field, new ConstantParam(this.type));
    }

    @Override
    public String getName() {
        return "CAST";
    }

    @Override
    public String format() {
        return String.format("%s(%s AS %s)", this.getName(), this.field.format(), this.type);
    }

    public FunctionParam getField() {
        return this.field;
    }

    public String getType() {
        return this.type;
    }

    public void setField(FunctionParam field) {
        this.field = field;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CastFunction)) {
            return false;
        }
        CastFunction other = (CastFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FunctionParam this$field = this.getField();
        FunctionParam other$field = other.getField();
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CastFunction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FunctionParam $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    public String toString() {
        return "CastFunction(field=" + this.getField() + ", type=" + this.getType() + ")";
    }

    public CastFunction() {
    }
}

