/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpServerAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.NetServerAttributesGetter;
import java.util.Collections;
import java.util.List;

public final class HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE> {
    final HttpServerAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter;
    final NetServerAttributesGetter<REQUEST, RESPONSE> netAttributesGetter;
    List<String> capturedRequestHeaders = Collections.emptyList();
    List<String> capturedResponseHeaders = Collections.emptyList();

    HttpServerAttributesExtractorBuilder(HttpServerAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter, NetServerAttributesGetter<REQUEST, RESPONSE> netAttributesGetter) {
        this.httpAttributesGetter = httpAttributesGetter;
        this.netAttributesGetter = netAttributesGetter;
    }

    @CanIgnoreReturnValue
    public HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE> setCapturedRequestHeaders(List<String> requestHeaders) {
        this.capturedRequestHeaders = requestHeaders;
        return this;
    }

    @CanIgnoreReturnValue
    public HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE> setCapturedResponseHeaders(List<String> responseHeaders) {
        this.capturedResponseHeaders = responseHeaders;
        return this;
    }

    public AttributesExtractor<REQUEST, RESPONSE> build() {
        return new HttpServerAttributesExtractor<REQUEST, RESPONSE>(this.httpAttributesGetter, this.netAttributesGetter, this.capturedRequestHeaders, this.capturedResponseHeaders);
    }
}

