/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.inner.client;

import org.apache.commons.lang3.tuple.Pair;
import org.apache.inlong.manager.client.api.ClientConfiguration;
import org.apache.inlong.manager.client.api.service.TemplateApi;
import org.apache.inlong.manager.client.api.util.ClientUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.stream.TemplateInfo;
import org.apache.inlong.manager.pojo.stream.TemplatePageRequest;
import org.apache.inlong.manager.pojo.stream.TemplateRequest;

public class TemplateClient {
    private final TemplateApi templateApi;

    public TemplateClient(ClientConfiguration configuration) {
        this.templateApi = (TemplateApi)ClientUtils.createRetrofit(configuration).create(TemplateApi.class);
    }

    public Integer save(TemplateRequest request) {
        Response<Integer> response = ClientUtils.executeHttpCall(this.templateApi.save(request));
        ClientUtils.assertRespSuccess(response);
        return (Integer)response.getData();
    }

    public Boolean exists(String templateName) {
        Preconditions.expectNotBlank((String)templateName, (ErrorCodeEnum)ErrorCodeEnum.TEMPLATE_INFO_INCORRECT);
        Response<Boolean> response = ClientUtils.executeHttpCall(this.templateApi.exists(templateName));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }

    public Pair<Boolean, String> update(TemplateRequest request) {
        Response<Boolean> resp = ClientUtils.executeHttpCall(this.templateApi.update(request));
        if (resp.getData() != null) {
            return Pair.of((Object)resp.getData(), (Object)resp.getErrMsg());
        }
        return Pair.of((Object)false, (Object)resp.getErrMsg());
    }

    public TemplateInfo get(String templateName) {
        Response<TemplateInfo> response = ClientUtils.executeHttpCall(this.templateApi.get(templateName));
        if (response.isSuccess()) {
            return (TemplateInfo)response.getData();
        }
        if (response.getErrMsg().contains("not exist")) {
            return null;
        }
        throw new RuntimeException(response.getErrMsg());
    }

    public PageResult<TemplateInfo> listByCondition(TemplatePageRequest request) {
        Response<PageResult<TemplateInfo>> response = ClientUtils.executeHttpCall(this.templateApi.listByCondition(request));
        ClientUtils.assertRespSuccess(response);
        return (PageResult)response.getData();
    }

    public boolean delete(String templateName) {
        Preconditions.expectNotBlank((String)templateName, (ErrorCodeEnum)ErrorCodeEnum.TEMPLATE_INFO_INCORRECT);
        Response<Boolean> response = ClientUtils.executeHttpCall(this.templateApi.delete(templateName));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }
}

