/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.manager.service;

import java.util.concurrent.CompletableFuture;
import org.apache.inlong.tubemq.manager.entry.TopicEntry;

public class TopicFuture {
    private int retryTime = 0;
    private final TopicEntry entry;
    private final CompletableFuture<TopicEntry> future;

    public TopicFuture(TopicEntry entry, CompletableFuture<TopicEntry> future) {
        this.entry = entry;
        this.future = future;
    }

    public void increaseRetryTime() {
        ++this.retryTime;
    }

    public void complete() {
        this.future.complete(this.entry);
    }

    public void completeExceptional() {
        this.future.completeExceptionally(new RuntimeException("exceed max retry " + this.retryTime + " adding"));
    }

    public int getRetryTime() {
        return this.retryTime;
    }

    public TopicEntry getEntry() {
        return this.entry;
    }

    public CompletableFuture<TopicEntry> getFuture() {
        return this.future;
    }
}

