/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.manager.service;

import com.google.gson.Gson;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.inlong.tubemq.manager.controller.TubeMQResult;
import org.apache.inlong.tubemq.manager.controller.group.request.DeleteOffsetReq;
import org.apache.inlong.tubemq.manager.controller.group.request.QueryOffsetReq;
import org.apache.inlong.tubemq.manager.controller.group.result.OffsetQueryRes;
import org.apache.inlong.tubemq.manager.controller.node.request.CloneOffsetReq;
import org.apache.inlong.tubemq.manager.entry.BrokerEntry;
import org.apache.inlong.tubemq.manager.repository.BrokerRepository;
import org.apache.inlong.tubemq.manager.service.TubeConst;
import org.apache.inlong.tubemq.manager.service.interfaces.BrokerService;
import org.apache.inlong.tubemq.manager.service.interfaces.MasterService;
import org.apache.inlong.tubemq.manager.utils.ConvertUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BrokerServiceImpl
implements BrokerService {
    @Autowired
    BrokerRepository brokerRepository;
    @Autowired
    MasterService masterService;
    private final Gson gson = new Gson();

    @Override
    public void resetBrokerRegions(long regionId, long clusterId) {
        List<BrokerEntry> brokerEntries = this.brokerRepository.findBrokerEntriesByRegionIdEqualsAndClusterIdEquals(regionId, clusterId);
        for (BrokerEntry brokerEntry : brokerEntries) {
            brokerEntry.setRegionId(TubeConst.DEFAULT_REGION);
            this.brokerRepository.save(brokerEntry);
        }
    }

    @Override
    public void updateBrokersRegion(List<Long> brokerIdList, Long regionId, Long clusterId) {
        List<BrokerEntry> brokerEntries = this.brokerRepository.findBrokerEntryByBrokerIdInAndClusterIdEquals(brokerIdList, clusterId);
        for (BrokerEntry brokerEntry : brokerEntries) {
            brokerEntry.setRegionId(regionId);
            this.brokerRepository.save(brokerEntry);
        }
    }

    @Override
    public boolean checkIfBrokersAllExist(List<Long> brokerIdList, long clusterId) {
        List<BrokerEntry> brokerEntries = this.brokerRepository.findBrokerEntryByBrokerIdInAndClusterIdEquals(brokerIdList, clusterId);
        List regionBrokerIdList = brokerEntries.stream().map(BrokerEntry::getBrokerId).collect(Collectors.toList());
        return regionBrokerIdList.containsAll(brokerIdList);
    }

    @Override
    public List<Long> getBrokerIdListInRegion(long regionId, long clusterId) {
        List<BrokerEntry> brokerEntries = this.brokerRepository.findBrokerEntriesByRegionIdEqualsAndClusterIdEquals(regionId, clusterId);
        List<Long> regionBrokerIdList = brokerEntries.stream().map(BrokerEntry::getBrokerId).collect(Collectors.toList());
        return regionBrokerIdList;
    }

    @Override
    public TubeMQResult cloneOffset(String brokerIp, int brokerWebPort, CloneOffsetReq req) {
        return this.requestMaster(brokerIp, brokerWebPort, req);
    }

    @Override
    public TubeMQResult deleteOffset(String brokerIp, int brokerWebPort, DeleteOffsetReq req) {
        return this.requestMaster(brokerIp, brokerWebPort, req);
    }

    public TubeMQResult requestMaster(String brokerIp, int brokerWebPort, Object req) {
        String url = "http://" + brokerIp + ":" + brokerWebPort + "/" + "webapi.htm" + "?" + ConvertUtils.convertReqToQueryStr(req);
        return this.masterService.requestMaster(url);
    }

    @Override
    public OffsetQueryRes queryOffset(String brokerIp, int brokerWebPort, QueryOffsetReq req) {
        String url = "http://" + brokerIp + ":" + brokerWebPort + "/" + "webapi.htm" + "?" + ConvertUtils.convertReqToQueryStr(req);
        return (OffsetQueryRes)this.gson.fromJson(this.masterService.queryMaster(url), OffsetQueryRes.class);
    }
}

