/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.node.load;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.InlongMetric;
import org.apache.inlong.sort.protocol.enums.FilterStrategy;
import org.apache.inlong.sort.protocol.node.LoadNode;
import org.apache.inlong.sort.protocol.node.format.Format;
import org.apache.inlong.sort.protocol.transformation.FieldRelation;
import org.apache.inlong.sort.protocol.transformation.FilterFunction;

@JsonTypeName(value="elasticsearchLoadNode")
public class ElasticsearchLoadNode
extends LoadNode
implements InlongMetric,
Serializable {
    private static final long serialVersionUID = -1L;
    @JsonProperty(value="index")
    @Nonnull
    private String index;
    @JsonProperty(value="hosts")
    @Nonnull
    private String hosts;
    @JsonProperty(value="username")
    @Nonnull
    private String username;
    @JsonProperty(value="password")
    @Nonnull
    private String password;
    @JsonProperty(value="documentType")
    private String documentType;
    @JsonProperty(value="primaryKey")
    private String primaryKey;
    @JsonProperty(value="version")
    private int version;
    @Nullable
    @JsonProperty(value="sinkMultipleEnable")
    private Boolean sinkMultipleEnable = false;
    @Nullable
    @JsonProperty(value="sinkMultipleFormat")
    private Format sinkMultipleFormat;
    @Nullable
    @JsonProperty(value="indexPattern")
    private String indexPattern;

    @JsonCreator
    public ElasticsearchLoadNode(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="fields") List<FieldInfo> fields, @JsonProperty(value="fieldRelations") List<FieldRelation> fieldRelationShips, @JsonProperty(value="filters") List<FilterFunction> filters, @JsonProperty(value="filterStrategy") FilterStrategy filterStrategy, @Nullable @JsonProperty(value="sinkParallelism") Integer sinkParallelism, @JsonProperty(value="properties") Map<String, String> properties, @Nonnull @JsonProperty(value="index") String index, @Nonnull @JsonProperty(value="hosts") String hosts, @Nonnull @JsonProperty(value="username") String username, @Nonnull @JsonProperty(value="password") String password, @Nonnull @JsonProperty(value="documentType") String documentType, @Nonnull @JsonProperty(value="primaryKey") String primaryKey, @JsonProperty(value="version") int version, @Nullable @JsonProperty(value="sinkMultipleEnable") Boolean sinkMultipleEnable, @Nullable @JsonProperty(value="sinkMultipleFormat") Format sinkMultipleFormat, @Nullable @JsonProperty(value="indexPattern") String indexPattern) {
        super(id, name, fields, fieldRelationShips, filters, filterStrategy, sinkParallelism, properties);
        this.password = Preconditions.checkNotNull(password, "password is null");
        this.username = Preconditions.checkNotNull(username, "username is null");
        this.hosts = Preconditions.checkNotNull(hosts, "hosts is null");
        this.index = Preconditions.checkNotNull(index, "index is null");
        this.documentType = documentType;
        this.primaryKey = primaryKey;
        this.version = version;
        this.sinkMultipleEnable = sinkMultipleEnable;
        this.sinkMultipleFormat = sinkMultipleFormat;
        this.indexPattern = indexPattern;
    }

    @Override
    public Map<String, String> tableOptions() {
        Map<String, String> options = super.tableOptions();
        options.put("connector", "elasticsearch-7-inlong");
        if (this.version == 5 || this.version == 6) {
            options.put("connector", "elasticsearch-6-inlong");
            options.put("document-type", this.documentType);
        }
        options.put("hosts", this.hosts);
        options.put("index", this.index);
        options.put("password", this.password);
        options.put("username", this.username);
        return options;
    }

    @Override
    public String genTableName() {
        return "node_" + super.getId() + "_" + this.index;
    }

    @Override
    public String getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElasticsearchLoadNode)) {
            return false;
        }
        ElasticsearchLoadNode other = (ElasticsearchLoadNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        Boolean this$sinkMultipleEnable = this.getSinkMultipleEnable();
        Boolean other$sinkMultipleEnable = other.getSinkMultipleEnable();
        if (this$sinkMultipleEnable == null ? other$sinkMultipleEnable != null : !((Object)this$sinkMultipleEnable).equals(other$sinkMultipleEnable)) {
            return false;
        }
        String this$index = this.getIndex();
        String other$index = other.getIndex();
        if (this$index == null ? other$index != null : !this$index.equals(other$index)) {
            return false;
        }
        String this$hosts = this.getHosts();
        String other$hosts = other.getHosts();
        if (this$hosts == null ? other$hosts != null : !this$hosts.equals(other$hosts)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$documentType = this.getDocumentType();
        String other$documentType = other.getDocumentType();
        if (this$documentType == null ? other$documentType != null : !this$documentType.equals(other$documentType)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        Format this$sinkMultipleFormat = this.getSinkMultipleFormat();
        Format other$sinkMultipleFormat = other.getSinkMultipleFormat();
        if (this$sinkMultipleFormat == null ? other$sinkMultipleFormat != null : !this$sinkMultipleFormat.equals(other$sinkMultipleFormat)) {
            return false;
        }
        String this$indexPattern = this.getIndexPattern();
        String other$indexPattern = other.getIndexPattern();
        return !(this$indexPattern == null ? other$indexPattern != null : !this$indexPattern.equals(other$indexPattern));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ElasticsearchLoadNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getVersion();
        Boolean $sinkMultipleEnable = this.getSinkMultipleEnable();
        result = result * 59 + ($sinkMultipleEnable == null ? 43 : ((Object)$sinkMultipleEnable).hashCode());
        String $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : $index.hashCode());
        String $hosts = this.getHosts();
        result = result * 59 + ($hosts == null ? 43 : $hosts.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $documentType = this.getDocumentType();
        result = result * 59 + ($documentType == null ? 43 : $documentType.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        Format $sinkMultipleFormat = this.getSinkMultipleFormat();
        result = result * 59 + ($sinkMultipleFormat == null ? 43 : $sinkMultipleFormat.hashCode());
        String $indexPattern = this.getIndexPattern();
        result = result * 59 + ($indexPattern == null ? 43 : $indexPattern.hashCode());
        return result;
    }

    @Nonnull
    public String getIndex() {
        return this.index;
    }

    @Nonnull
    public String getHosts() {
        return this.hosts;
    }

    @Nonnull
    public String getUsername() {
        return this.username;
    }

    @Nonnull
    public String getPassword() {
        return this.password;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public int getVersion() {
        return this.version;
    }

    @Nullable
    public Boolean getSinkMultipleEnable() {
        return this.sinkMultipleEnable;
    }

    @Nullable
    public Format getSinkMultipleFormat() {
        return this.sinkMultipleFormat;
    }

    @Nullable
    public String getIndexPattern() {
        return this.indexPattern;
    }

    public void setIndex(@Nonnull String index) {
        if (index == null) {
            throw new NullPointerException("index is marked non-null but is null");
        }
        this.index = index;
    }

    public void setHosts(@Nonnull String hosts) {
        if (hosts == null) {
            throw new NullPointerException("hosts is marked non-null but is null");
        }
        this.hosts = hosts;
    }

    public void setUsername(@Nonnull String username) {
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        this.username = username;
    }

    public void setPassword(@Nonnull String password) {
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        this.password = password;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setSinkMultipleEnable(@Nullable Boolean sinkMultipleEnable) {
        this.sinkMultipleEnable = sinkMultipleEnable;
    }

    public void setSinkMultipleFormat(@Nullable Format sinkMultipleFormat) {
        this.sinkMultipleFormat = sinkMultipleFormat;
    }

    public void setIndexPattern(@Nullable String indexPattern) {
        this.indexPattern = indexPattern;
    }

    @Override
    public String toString() {
        return "ElasticsearchLoadNode(index=" + this.getIndex() + ", hosts=" + this.getHosts() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", documentType=" + this.getDocumentType() + ", primaryKey=" + this.getPrimaryKey() + ", version=" + this.getVersion() + ", sinkMultipleEnable=" + this.getSinkMultipleEnable() + ", sinkMultipleFormat=" + this.getSinkMultipleFormat() + ", indexPattern=" + this.getIndexPattern() + ")";
    }

    public ElasticsearchLoadNode() {
    }
}

