/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.deserialization;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonAlias;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.inlong.sort.protocol.constant.Constant;
import org.apache.inlong.sort.protocol.deserialization.InLongMsgDeserializationInfo;

@JsonIgnoreProperties(ignoreUnknown=true)
public class KvDeserializationInfo
extends InLongMsgDeserializationInfo {
    private static final long serialVersionUID = -3182881360079888043L;
    private final char entrySplitter;
    private final char kvSplitter;
    private final String streamId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    private final Character escapeChar;
    @JsonProperty(value="delete_escape_char_while_deserialize")
    @Nullable
    private final Boolean deleteEscapeCharWhileDes;
    @JsonProperty(value="auto_append_escape_char_after_deserialize")
    @Nullable
    private final Boolean autoAppendEscapeCharAfterDes;

    public KvDeserializationInfo(@JsonProperty(value="entry_splitter") char entrySplitter, @JsonProperty(value="kv_splitter") char kvSplitter) {
        this("-", entrySplitter, kvSplitter, null);
    }

    public KvDeserializationInfo(@JsonProperty(value="entry_splitter") char entrySplitter, @JsonProperty(value="kv_splitter") char kvSplitter, @JsonProperty(value="escape_char") @Nullable Character escapeChar) {
        this("-", entrySplitter, kvSplitter, escapeChar);
    }

    @JsonCreator
    public KvDeserializationInfo(@JsonProperty(value="streamId") @JsonAlias(value={"tid"}) String streamId, @JsonProperty(value="entry_splitter") char entrySplitter, @JsonProperty(value="kv_splitter") char kvSplitter, @JsonProperty(value="escape_char") @Nullable Character escapeChar) {
        this(streamId, entrySplitter, kvSplitter, escapeChar, Constant.DELETE_ESCAPE_CHAR_WHILE_DESERIALIZE_DEFAULT, Constant.AUTO_APPEND_ESCAPE_CHAR_AFTER_DESERIALIZE_DEFAULT);
    }

    @JsonCreator
    public KvDeserializationInfo(@JsonProperty(value="streamId") @JsonAlias(value={"tid"}) String streamId, @JsonProperty(value="entry_splitter") char entrySplitter, @JsonProperty(value="kv_splitter") char kvSplitter, @JsonProperty(value="escape_char") @Nullable Character escapeChar, @JsonProperty(value="delete_escape_char_while_deserialize") @Nullable Boolean deleteEscapeCharWhileDes, @JsonProperty(value="auto_append_escape_char_after_deserialize") @Nullable Boolean autoAppendEscapeCharAfterDes) {
        super(streamId);
        this.streamId = StringUtils.isEmpty(streamId) ? "-" : streamId;
        this.entrySplitter = entrySplitter;
        this.kvSplitter = kvSplitter;
        this.escapeChar = escapeChar;
        this.deleteEscapeCharWhileDes = deleteEscapeCharWhileDes;
        this.autoAppendEscapeCharAfterDes = autoAppendEscapeCharAfterDes;
    }

    @JsonProperty(value="entry_splitter")
    public char getEntrySplitter() {
        return this.entrySplitter;
    }

    @JsonProperty(value="kv_splitter")
    public char getKvSplitter() {
        return this.kvSplitter;
    }

    @JsonProperty(value="escape_char")
    @Nullable
    public Character getEscapeChar() {
        return this.escapeChar;
    }

    @Override
    @JsonProperty(value="streamId")
    public String getStreamId() {
        return this.streamId;
    }

    @JsonProperty(value="delete_escape_char_while_deserialize")
    @Nullable
    public Boolean getDeleteEscapeCharWhileDes() {
        if (this.deleteEscapeCharWhileDes != null) {
            return this.deleteEscapeCharWhileDes;
        }
        return Constant.DELETE_ESCAPE_CHAR_WHILE_DESERIALIZE_DEFAULT;
    }

    @JsonProperty(value="auto_append_escape_char_after_deserialize")
    @Nullable
    public Boolean getAutoAppendEscapeCharAfterDes() {
        if (this.autoAppendEscapeCharAfterDes != null) {
            return this.autoAppendEscapeCharAfterDes;
        }
        return Constant.AUTO_APPEND_ESCAPE_CHAR_AFTER_DESERIALIZE_DEFAULT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KvDeserializationInfo other = (KvDeserializationInfo)o;
        return Objects.equals(this.streamId, other.getStreamId()) && this.entrySplitter == other.entrySplitter && this.kvSplitter == other.kvSplitter && Objects.equals(this.escapeChar, other.escapeChar) && Objects.equals(this.deleteEscapeCharWhileDes, other.deleteEscapeCharWhileDes) && Objects.equals(this.autoAppendEscapeCharAfterDes, other.autoAppendEscapeCharAfterDes);
    }
}

