/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.inlongmsgkv;

import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.types.Row;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.RowFormatInfo;
import org.apache.inlong.sort.formats.inlongmsg.row.AbstractInLongMsgMixedFormatConverter;
import org.apache.inlong.sort.formats.inlongmsg.row.InLongMsgMixedFormatConverterBuilder;
import org.apache.inlong.sort.formats.inlongmsg.row.InLongMsgUtils;
import org.apache.inlong.sort.formats.inlongmsgkv.InLongMsgKvUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InLongMsgKvMixedFormatConverter
extends AbstractInLongMsgMixedFormatConverter {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(InLongMsgKvMixedFormatConverter.class);
    @Nonnull
    private final RowFormatInfo rowFormatInfo;
    @Nullable
    private final String timeFieldName;
    @Nullable
    private final String attributesFieldName;
    private final String nullLiteral;

    public InLongMsgKvMixedFormatConverter(@Nonnull RowFormatInfo rowFormatInfo, @Nullable String timeFieldName, @Nullable String attributesFieldName, @Nullable String nullLiteral, boolean ignoreErrors) {
        super(ignoreErrors);
        this.rowFormatInfo = rowFormatInfo;
        this.timeFieldName = timeFieldName;
        this.attributesFieldName = attributesFieldName;
        this.nullLiteral = nullLiteral;
    }

    public TypeInformation<Row> getProducedType() {
        return InLongMsgUtils.decorateRowTypeWithNeededHeadFields(this.timeFieldName, this.attributesFieldName, this.rowFormatInfo);
    }

    @Override
    public List<Row> convertRows(Map<String, String> attributes, byte[] data, String streamId, Timestamp time, List<String> predefinedFields, List<String> fields, Map<String, String> entries) throws Exception {
        Row dataRow = InLongMsgKvUtils.deserializeRow(this.rowFormatInfo, this.nullLiteral, predefinedFields, entries);
        Row row = InLongMsgUtils.decorateRowWithNeededHeadFields(this.timeFieldName, this.attributesFieldName, time, attributes, dataRow);
        return Collections.singletonList(row);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        InLongMsgKvMixedFormatConverter that = (InLongMsgKvMixedFormatConverter)object;
        return this.rowFormatInfo.equals(that.rowFormatInfo) && Objects.equals(this.timeFieldName, that.timeFieldName) && Objects.equals(this.attributesFieldName, that.attributesFieldName) && Objects.equals(this.nullLiteral, that.nullLiteral);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.rowFormatInfo, this.timeFieldName, this.attributesFieldName, this.nullLiteral);
    }

    public static class Builder
    extends InLongMsgMixedFormatConverterBuilder {
        public Builder(RowFormatInfo rowFormatInfo) {
            super(rowFormatInfo);
        }

        public InLongMsgKvMixedFormatConverter build() {
            return new InLongMsgKvMixedFormatConverter(this.rowFormatInfo, this.timeFieldName, this.attributesFieldName, this.nullLiteral, this.ignoreErrors);
        }
    }
}

