/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.inlongmsgkv;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.types.Row;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.RowFormatInfo;
import org.apache.inlong.sort.formats.base.TableFormatConstants;
import org.apache.inlong.sort.formats.base.TextFormatBuilder;
import org.apache.inlong.sort.formats.inlongmsg.FailureHandler;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgBody;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgHead;
import org.apache.inlong.sort.formats.inlongmsg.row.AbstractInLongMsgFormatDeserializer;
import org.apache.inlong.sort.formats.inlongmsg.row.InLongMsgUtils;
import org.apache.inlong.sort.formats.inlongmsgkv.InLongMsgKvUtils;

public final class InLongMsgKvFormatDeserializer
extends AbstractInLongMsgFormatDeserializer {
    private static final long serialVersionUID = 1L;
    @Nonnull
    private final RowFormatInfo rowFormatInfo;
    @Nullable
    private final String timeFieldName;
    @Nullable
    private final String attributesFieldName;
    @Nonnull
    private final String charset;
    @Nonnull
    private final Character entryDelimiter;
    @Nonnull
    private final Character kvDelimiter;
    @Nullable
    private final Character lineDelimiter;
    @Nullable
    private final Character escapeChar;
    @Nullable
    private final Character quoteChar;
    @Nullable
    private final String nullLiteral;
    private boolean retainPredefinedField = true;

    public InLongMsgKvFormatDeserializer(@Nonnull RowFormatInfo rowFormatInfo, @Nullable String timeFieldName, @Nullable String attributesFieldName, @Nonnull String charset, @Nonnull Character entryDelimiter, @Nonnull Character kvDelimiter, @Nullable Character lineDelimiter, @Nullable Character escapeChar, @Nullable Character quoteChar, @Nullable String nullLiteral, @Nonnull Boolean ignoreErrors, boolean retainPredefinedField) {
        this(rowFormatInfo, timeFieldName, attributesFieldName, charset, entryDelimiter, kvDelimiter, lineDelimiter, escapeChar, quoteChar, nullLiteral, InLongMsgUtils.getDefaultExceptionHandler(ignoreErrors));
        this.retainPredefinedField = retainPredefinedField;
    }

    public InLongMsgKvFormatDeserializer(@Nonnull RowFormatInfo rowFormatInfo, @Nullable String timeFieldName, @Nullable String attributesFieldName, @Nonnull String charset, @Nonnull Character entryDelimiter, @Nonnull Character kvDelimiter, @Nullable Character lineDelimiter, @Nullable Character escapeChar, @Nullable Character quoteChar, @Nullable String nullLiteral, @Nonnull Boolean ignoreErrors) {
        this(rowFormatInfo, timeFieldName, attributesFieldName, charset, entryDelimiter, kvDelimiter, lineDelimiter, escapeChar, quoteChar, nullLiteral, InLongMsgUtils.getDefaultExceptionHandler(ignoreErrors));
    }

    public InLongMsgKvFormatDeserializer(@Nonnull RowFormatInfo rowFormatInfo, @Nullable String timeFieldName, @Nullable String attributesFieldName, @Nonnull String charset, @Nonnull Character entryDelimiter, @Nonnull Character kvDelimiter, @Nullable Character lineDelimiter, @Nullable Character escapeChar, @Nullable Character quoteChar, @Nullable String nullLiteral, @Nonnull FailureHandler failureHandler) {
        super(failureHandler);
        this.rowFormatInfo = rowFormatInfo;
        this.timeFieldName = timeFieldName;
        this.attributesFieldName = attributesFieldName;
        this.charset = charset;
        this.entryDelimiter = entryDelimiter;
        this.kvDelimiter = kvDelimiter;
        this.lineDelimiter = lineDelimiter;
        this.escapeChar = escapeChar;
        this.quoteChar = quoteChar;
        this.nullLiteral = nullLiteral;
    }

    public TypeInformation<Row> getProducedType() {
        return InLongMsgUtils.decorateRowTypeWithNeededHeadFields(this.timeFieldName, this.attributesFieldName, this.rowFormatInfo);
    }

    @Override
    protected InLongMsgHead parseHead(String attr) {
        return InLongMsgKvUtils.parseHead(attr);
    }

    @Override
    protected List<InLongMsgBody> parseBodyList(byte[] bytes) {
        return InLongMsgKvUtils.parseBodyList(bytes, this.charset, this.entryDelimiter.charValue(), this.kvDelimiter.charValue(), this.lineDelimiter, this.escapeChar, this.quoteChar);
    }

    @Override
    protected List<Row> convertRows(InLongMsgHead head, InLongMsgBody body) throws Exception {
        Row dataRow = InLongMsgKvUtils.deserializeRow(this.rowFormatInfo, this.nullLiteral, this.retainPredefinedField ? head.getPredefinedFields() : Collections.emptyList(), body.getEntries());
        Row row = InLongMsgUtils.decorateRowWithNeededHeadFields(this.timeFieldName, this.attributesFieldName, head.getTime(), head.getAttributes(), dataRow);
        return Collections.singletonList(row);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InLongMsgKvFormatDeserializer that = (InLongMsgKvFormatDeserializer)((Object)o);
        return this.rowFormatInfo.equals(that.rowFormatInfo) && Objects.equals(this.timeFieldName, that.timeFieldName) && Objects.equals(this.attributesFieldName, that.attributesFieldName) && this.charset.equals(that.charset) && this.entryDelimiter.equals(that.entryDelimiter) && this.kvDelimiter.equals(that.kvDelimiter) && Objects.equals(this.lineDelimiter, that.lineDelimiter) && Objects.equals(this.escapeChar, that.escapeChar) && Objects.equals(this.quoteChar, that.quoteChar) && Objects.equals(this.nullLiteral, that.nullLiteral) && Objects.equals(this.retainPredefinedField, that.retainPredefinedField);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.rowFormatInfo, this.timeFieldName, this.attributesFieldName, this.charset, this.entryDelimiter, this.kvDelimiter, this.lineDelimiter, this.escapeChar, this.quoteChar, this.nullLiteral, this.retainPredefinedField);
    }

    public static class Builder
    extends TextFormatBuilder<Builder> {
        private String timeFieldName = "inlongmsg_time";
        private String attributesFieldName = "inlongmsg_attributes";
        private Character entryDelimiter = Character.valueOf('&');
        private Character kvDelimiter = Character.valueOf('=');
        private Character lineDelimiter = TableFormatConstants.DEFAULT_LINE_DELIMITER;
        private Boolean retainPredefinedField = true;

        public Builder(RowFormatInfo rowFormatInfo) {
            super(rowFormatInfo);
            this.charset = "ISO_8859_1";
        }

        public Builder setTimeFieldName(String timeFieldName) {
            this.timeFieldName = timeFieldName;
            return this;
        }

        public Builder setAttributesFieldName(String attributesFieldName) {
            this.attributesFieldName = attributesFieldName;
            return this;
        }

        public Builder setEntryDelimiter(Character entryDelimiter) {
            this.entryDelimiter = entryDelimiter;
            return this;
        }

        public Builder setKvDelimiter(Character kvDelimiter) {
            this.kvDelimiter = kvDelimiter;
            return this;
        }

        public Builder setLineDelimiter(Character lineDelimiter) {
            this.lineDelimiter = lineDelimiter;
            return this;
        }

        public Builder setRetainPredefinedField(Boolean retainPredefinedField) {
            this.retainPredefinedField = retainPredefinedField;
            return this;
        }

        @Override
        public Builder configure(DescriptorProperties descriptorProperties) {
            super.configure(descriptorProperties);
            descriptorProperties.getOptionalString("format.time-field-name").ifPresent(this::setTimeFieldName);
            descriptorProperties.getOptionalString("format.attributes-field-name").ifPresent(this::setAttributesFieldName);
            descriptorProperties.getOptionalCharacter("format.entry-delimiter").ifPresent(this::setEntryDelimiter);
            descriptorProperties.getOptionalCharacter("format.kv-delimiter").ifPresent(this::setKvDelimiter);
            descriptorProperties.getOptionalCharacter("format.line-delimiter").ifPresent(this::setLineDelimiter);
            descriptorProperties.getOptionalBoolean("format.retain-predefined-field").ifPresent(this::setRetainPredefinedField);
            return this;
        }

        public InLongMsgKvFormatDeserializer build() {
            return new InLongMsgKvFormatDeserializer(this.rowFormatInfo, this.timeFieldName, this.attributesFieldName, this.charset, this.entryDelimiter, this.kvDelimiter, this.lineDelimiter, this.escapeChar, this.quoteChar, this.nullLiteral, this.ignoreErrors, this.retainPredefinedField);
        }
    }
}

