/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort;

import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.inlong.common.bounded.Boundaries;
import org.apache.inlong.common.bounded.BoundaryType;
import org.apache.inlong.sort.configuration.Configuration;
import org.apache.inlong.sort.configuration.Constants;
import org.apache.inlong.sort.parser.Parser;
import org.apache.inlong.sort.parser.impl.FlinkSqlParser;
import org.apache.inlong.sort.parser.impl.NativeFlinkSqlParser;
import org.apache.inlong.sort.parser.result.ParseResult;
import org.apache.inlong.sort.protocol.GroupInfo;
import org.apache.inlong.sort.protocol.node.ExtractNode;
import org.apache.inlong.sort.util.ParameterTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Entrance {
    private static final Logger log = LoggerFactory.getLogger(Entrance.class);
    public static final String BATCH_MODE = "batch";

    public static void main(String[] args) throws Exception {
        Parser parser;
        ParameterTool parameterTool = ParameterTool.fromArgs(args);
        Configuration config = parameterTool.getConfiguration();
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.enableCheckpointing((long)config.getInteger(Constants.CHECKPOINT_INTERVAL_MS));
        env.getCheckpointConfig().setMinPauseBetweenCheckpoints((long)config.getInteger(Constants.MIN_PAUSE_BETWEEN_CHECKPOINTS_MS));
        env.getCheckpointConfig().setCheckpointTimeout((long)config.getInteger(Constants.CHECKPOINT_TIMEOUT_MS));
        env.getCheckpointConfig().setMaxConcurrentCheckpoints(1);
        String runtimeExecutionMode = config.getString(Constants.RUNTIME_EXECUTION_MODE);
        EnvironmentSettings settings = BATCH_MODE.equalsIgnoreCase(runtimeExecutionMode) ? EnvironmentSettings.newInstance().inBatchMode().build() : EnvironmentSettings.newInstance().inStreamingMode().build();
        StreamTableEnvironment tableEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env, (EnvironmentSettings)settings);
        tableEnv.getConfig().getConfiguration().setString("pipeline.name", config.getString(Constants.JOB_NAME));
        tableEnv.getConfig().getConfiguration().setString("table.exec.sink.upsert-materialize", config.getString(Constants.UPSERT_MATERIALIZE));
        tableEnv.getConfig().getConfiguration().setString("table.exec.sink.not-null-enforcer", config.getString(Constants.NOT_NULL_ENFORCER));
        tableEnv.getConfig().getConfiguration().setBoolean(Constants.ENABLE_LOG_REPORT.key(), config.getBoolean(Constants.ENABLE_LOG_REPORT));
        String sqlFile = config.getString(Constants.SQL_SCRIPT_FILE);
        if (StringUtils.isEmpty(sqlFile)) {
            GroupInfo groupInfo = Entrance.getGroupInfoFromFile(config.getString(Constants.GROUP_INFO_FILE));
            if (StringUtils.isNotEmpty(config.getString(Constants.METRICS_AUDIT_PROXY_HOSTS))) {
                groupInfo.getProperties().putIfAbsent(Constants.METRICS_AUDIT_PROXY_HOSTS.key(), config.getString(Constants.METRICS_AUDIT_PROXY_HOSTS));
            }
            Entrance.fillInSourceBoundariesIfNeeded(runtimeExecutionMode, groupInfo, config);
            parser = FlinkSqlParser.getInstance((TableEnvironment)tableEnv, groupInfo);
        } else {
            String statements = Entrance.getStatementSetFromFile(sqlFile);
            parser = NativeFlinkSqlParser.getInstance((TableEnvironment)tableEnv, statements);
        }
        ParseResult parseResult = Preconditions.checkNotNull(parser.parse(), "parse result is null");
        parseResult.execute();
    }

    private static void fillInSourceBoundariesIfNeeded(String runtimeExecutionMode, GroupInfo groupInfo, Configuration configuration) {
        if (!BATCH_MODE.equalsIgnoreCase(runtimeExecutionMode)) {
            return;
        }
        String type = configuration.getString(Constants.SOURCE_BOUNDARY_TYPE);
        String lowerBoundary = configuration.getString(Constants.SOURCE_LOWER_BOUNDARY);
        String upperBoundary = configuration.getString(Constants.SOURCE_UPPER_BOUNDARY);
        log.info("Filling in source boundaries for group: {}, with execution mode: {}, boundaryType: {}, lowerBoundary: {}, upperBoundary: {}", groupInfo.getGroupId(), runtimeExecutionMode, type, lowerBoundary, upperBoundary);
        BoundaryType boundaryType = BoundaryType.getInstance(type);
        if (boundaryType == null) {
            throw new RuntimeException("Unknown boundary type: " + type);
        }
        Boundaries boundaries = new Boundaries(lowerBoundary, upperBoundary, boundaryType);
        groupInfo.getStreams().forEach(streamInfo -> streamInfo.getNodes().forEach(node -> {
            if (node instanceof ExtractNode) {
                ((ExtractNode)node).fillInBoundaries(boundaries);
            }
        }));
    }

    private static String getStatementSetFromFile(String fileName) throws IOException {
        return Files.asCharSource(new File(fileName), StandardCharsets.UTF_8).read();
    }

    private static GroupInfo getGroupInfoFromFile(String fileName) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        return objectMapper.readValue(new File(fileName), GroupInfo.class);
    }
}

