/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.common.heartbeat;

import com.google.common.base.Joiner;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.inlong.common.enums.NodeSrvStatus;
import org.apache.inlong.common.heartbeat.AddressInfo;
import org.apache.inlong.common.heartbeat.ComponentHeartbeat;
import org.apache.inlong.common.heartbeat.GroupHeartbeat;
import org.apache.inlong.common.heartbeat.StreamHeartbeat;

public class HeartbeatMsg {
    private NodeSrvStatus nodeSrvStatus = NodeSrvStatus.OK;
    private String ip;
    private String port;
    private List<AddressInfo> addressInfos;
    private String protocolType;
    private String componentType;
    private String reportSourceType;
    private Long reportTime;
    private String clusterName = "default";
    private String clusterTag;
    private String nodeGroup;
    private String extTag;
    private String inCharges = "admin";
    private List<GroupHeartbeat> groupHeartbeats;
    private List<StreamHeartbeat> streamHeartbeats;
    private Integer load = 65535;

    public ComponentHeartbeat componentHeartbeat() {
        if (this.addressInfos != null) {
            this.port = Joiner.on(",").join(this.addressInfos.stream().map(AddressInfo::getPort).collect(Collectors.toList()));
            this.ip = Joiner.on(",").join(this.addressInfos.stream().map(AddressInfo::getIp).collect(Collectors.toList()));
            this.reportSourceType = Joiner.on(",").join(this.addressInfos.stream().map(AddressInfo::getReportSourceType).collect(Collectors.toList()));
            this.protocolType = Joiner.on(",").join(this.addressInfos.stream().map(AddressInfo::getProtocolType).collect(Collectors.toList()));
        }
        return new ComponentHeartbeat(this.nodeSrvStatus, this.clusterTag, this.extTag, this.clusterName, this.componentType, this.ip, this.port, this.inCharges, this.protocolType, this.load);
    }

    public static HeartbeatMsgBuilder builder() {
        return new HeartbeatMsgBuilder();
    }

    public NodeSrvStatus getNodeSrvStatus() {
        return this.nodeSrvStatus;
    }

    public String getIp() {
        return this.ip;
    }

    public String getPort() {
        return this.port;
    }

    public List<AddressInfo> getAddressInfos() {
        return this.addressInfos;
    }

    public String getProtocolType() {
        return this.protocolType;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public String getReportSourceType() {
        return this.reportSourceType;
    }

    public Long getReportTime() {
        return this.reportTime;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getClusterTag() {
        return this.clusterTag;
    }

    public String getNodeGroup() {
        return this.nodeGroup;
    }

    public String getExtTag() {
        return this.extTag;
    }

    public String getInCharges() {
        return this.inCharges;
    }

    public List<GroupHeartbeat> getGroupHeartbeats() {
        return this.groupHeartbeats;
    }

    public List<StreamHeartbeat> getStreamHeartbeats() {
        return this.streamHeartbeats;
    }

    public Integer getLoad() {
        return this.load;
    }

    public void setNodeSrvStatus(NodeSrvStatus nodeSrvStatus) {
        this.nodeSrvStatus = nodeSrvStatus;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setAddressInfos(List<AddressInfo> addressInfos) {
        this.addressInfos = addressInfos;
    }

    public void setProtocolType(String protocolType) {
        this.protocolType = protocolType;
    }

    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    public void setReportSourceType(String reportSourceType) {
        this.reportSourceType = reportSourceType;
    }

    public void setReportTime(Long reportTime) {
        this.reportTime = reportTime;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setClusterTag(String clusterTag) {
        this.clusterTag = clusterTag;
    }

    public void setNodeGroup(String nodeGroup) {
        this.nodeGroup = nodeGroup;
    }

    public void setExtTag(String extTag) {
        this.extTag = extTag;
    }

    public void setInCharges(String inCharges) {
        this.inCharges = inCharges;
    }

    public void setGroupHeartbeats(List<GroupHeartbeat> groupHeartbeats) {
        this.groupHeartbeats = groupHeartbeats;
    }

    public void setStreamHeartbeats(List<StreamHeartbeat> streamHeartbeats) {
        this.streamHeartbeats = streamHeartbeats;
    }

    public void setLoad(Integer load) {
        this.load = load;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HeartbeatMsg)) {
            return false;
        }
        HeartbeatMsg other = (HeartbeatMsg)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$reportTime = this.getReportTime();
        Long other$reportTime = other.getReportTime();
        if (this$reportTime == null ? other$reportTime != null : !((Object)this$reportTime).equals(other$reportTime)) {
            return false;
        }
        Integer this$load = this.getLoad();
        Integer other$load = other.getLoad();
        if (this$load == null ? other$load != null : !((Object)this$load).equals(other$load)) {
            return false;
        }
        NodeSrvStatus this$nodeSrvStatus = this.getNodeSrvStatus();
        NodeSrvStatus other$nodeSrvStatus = other.getNodeSrvStatus();
        if (this$nodeSrvStatus == null ? other$nodeSrvStatus != null : !((Object)((Object)this$nodeSrvStatus)).equals((Object)other$nodeSrvStatus)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        String this$port = this.getPort();
        String other$port = other.getPort();
        if (this$port == null ? other$port != null : !this$port.equals(other$port)) {
            return false;
        }
        List<AddressInfo> this$addressInfos = this.getAddressInfos();
        List<AddressInfo> other$addressInfos = other.getAddressInfos();
        if (this$addressInfos == null ? other$addressInfos != null : !((Object)this$addressInfos).equals(other$addressInfos)) {
            return false;
        }
        String this$protocolType = this.getProtocolType();
        String other$protocolType = other.getProtocolType();
        if (this$protocolType == null ? other$protocolType != null : !this$protocolType.equals(other$protocolType)) {
            return false;
        }
        String this$componentType = this.getComponentType();
        String other$componentType = other.getComponentType();
        if (this$componentType == null ? other$componentType != null : !this$componentType.equals(other$componentType)) {
            return false;
        }
        String this$reportSourceType = this.getReportSourceType();
        String other$reportSourceType = other.getReportSourceType();
        if (this$reportSourceType == null ? other$reportSourceType != null : !this$reportSourceType.equals(other$reportSourceType)) {
            return false;
        }
        String this$clusterName = this.getClusterName();
        String other$clusterName = other.getClusterName();
        if (this$clusterName == null ? other$clusterName != null : !this$clusterName.equals(other$clusterName)) {
            return false;
        }
        String this$clusterTag = this.getClusterTag();
        String other$clusterTag = other.getClusterTag();
        if (this$clusterTag == null ? other$clusterTag != null : !this$clusterTag.equals(other$clusterTag)) {
            return false;
        }
        String this$nodeGroup = this.getNodeGroup();
        String other$nodeGroup = other.getNodeGroup();
        if (this$nodeGroup == null ? other$nodeGroup != null : !this$nodeGroup.equals(other$nodeGroup)) {
            return false;
        }
        String this$extTag = this.getExtTag();
        String other$extTag = other.getExtTag();
        if (this$extTag == null ? other$extTag != null : !this$extTag.equals(other$extTag)) {
            return false;
        }
        String this$inCharges = this.getInCharges();
        String other$inCharges = other.getInCharges();
        if (this$inCharges == null ? other$inCharges != null : !this$inCharges.equals(other$inCharges)) {
            return false;
        }
        List<GroupHeartbeat> this$groupHeartbeats = this.getGroupHeartbeats();
        List<GroupHeartbeat> other$groupHeartbeats = other.getGroupHeartbeats();
        if (this$groupHeartbeats == null ? other$groupHeartbeats != null : !((Object)this$groupHeartbeats).equals(other$groupHeartbeats)) {
            return false;
        }
        List<StreamHeartbeat> this$streamHeartbeats = this.getStreamHeartbeats();
        List<StreamHeartbeat> other$streamHeartbeats = other.getStreamHeartbeats();
        return !(this$streamHeartbeats == null ? other$streamHeartbeats != null : !((Object)this$streamHeartbeats).equals(other$streamHeartbeats));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HeartbeatMsg;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $reportTime = this.getReportTime();
        result = result * 59 + ($reportTime == null ? 43 : ((Object)$reportTime).hashCode());
        Integer $load = this.getLoad();
        result = result * 59 + ($load == null ? 43 : ((Object)$load).hashCode());
        NodeSrvStatus $nodeSrvStatus = this.getNodeSrvStatus();
        result = result * 59 + ($nodeSrvStatus == null ? 43 : ((Object)((Object)$nodeSrvStatus)).hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        String $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : $port.hashCode());
        List<AddressInfo> $addressInfos = this.getAddressInfos();
        result = result * 59 + ($addressInfos == null ? 43 : ((Object)$addressInfos).hashCode());
        String $protocolType = this.getProtocolType();
        result = result * 59 + ($protocolType == null ? 43 : $protocolType.hashCode());
        String $componentType = this.getComponentType();
        result = result * 59 + ($componentType == null ? 43 : $componentType.hashCode());
        String $reportSourceType = this.getReportSourceType();
        result = result * 59 + ($reportSourceType == null ? 43 : $reportSourceType.hashCode());
        String $clusterName = this.getClusterName();
        result = result * 59 + ($clusterName == null ? 43 : $clusterName.hashCode());
        String $clusterTag = this.getClusterTag();
        result = result * 59 + ($clusterTag == null ? 43 : $clusterTag.hashCode());
        String $nodeGroup = this.getNodeGroup();
        result = result * 59 + ($nodeGroup == null ? 43 : $nodeGroup.hashCode());
        String $extTag = this.getExtTag();
        result = result * 59 + ($extTag == null ? 43 : $extTag.hashCode());
        String $inCharges = this.getInCharges();
        result = result * 59 + ($inCharges == null ? 43 : $inCharges.hashCode());
        List<GroupHeartbeat> $groupHeartbeats = this.getGroupHeartbeats();
        result = result * 59 + ($groupHeartbeats == null ? 43 : ((Object)$groupHeartbeats).hashCode());
        List<StreamHeartbeat> $streamHeartbeats = this.getStreamHeartbeats();
        result = result * 59 + ($streamHeartbeats == null ? 43 : ((Object)$streamHeartbeats).hashCode());
        return result;
    }

    public String toString() {
        return "HeartbeatMsg(nodeSrvStatus=" + (Object)((Object)this.getNodeSrvStatus()) + ", ip=" + this.getIp() + ", port=" + this.getPort() + ", addressInfos=" + this.getAddressInfos() + ", protocolType=" + this.getProtocolType() + ", componentType=" + this.getComponentType() + ", reportSourceType=" + this.getReportSourceType() + ", reportTime=" + this.getReportTime() + ", clusterName=" + this.getClusterName() + ", clusterTag=" + this.getClusterTag() + ", nodeGroup=" + this.getNodeGroup() + ", extTag=" + this.getExtTag() + ", inCharges=" + this.getInCharges() + ", groupHeartbeats=" + this.getGroupHeartbeats() + ", streamHeartbeats=" + this.getStreamHeartbeats() + ", load=" + this.getLoad() + ")";
    }

    public HeartbeatMsg(NodeSrvStatus nodeSrvStatus, String ip, String port, List<AddressInfo> addressInfos, String protocolType, String componentType, String reportSourceType, Long reportTime, String clusterName, String clusterTag, String nodeGroup, String extTag, String inCharges, List<GroupHeartbeat> groupHeartbeats, List<StreamHeartbeat> streamHeartbeats, Integer load) {
        this.nodeSrvStatus = nodeSrvStatus;
        this.ip = ip;
        this.port = port;
        this.addressInfos = addressInfos;
        this.protocolType = protocolType;
        this.componentType = componentType;
        this.reportSourceType = reportSourceType;
        this.reportTime = reportTime;
        this.clusterName = clusterName;
        this.clusterTag = clusterTag;
        this.nodeGroup = nodeGroup;
        this.extTag = extTag;
        this.inCharges = inCharges;
        this.groupHeartbeats = groupHeartbeats;
        this.streamHeartbeats = streamHeartbeats;
        this.load = load;
    }

    public HeartbeatMsg() {
    }

    public static class HeartbeatMsgBuilder {
        private NodeSrvStatus nodeSrvStatus;
        private String ip;
        private String port;
        private List<AddressInfo> addressInfos;
        private String protocolType;
        private String componentType;
        private String reportSourceType;
        private Long reportTime;
        private String clusterName;
        private String clusterTag;
        private String nodeGroup;
        private String extTag;
        private String inCharges;
        private List<GroupHeartbeat> groupHeartbeats;
        private List<StreamHeartbeat> streamHeartbeats;
        private Integer load;

        HeartbeatMsgBuilder() {
        }

        public HeartbeatMsgBuilder nodeSrvStatus(NodeSrvStatus nodeSrvStatus) {
            this.nodeSrvStatus = nodeSrvStatus;
            return this;
        }

        public HeartbeatMsgBuilder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public HeartbeatMsgBuilder port(String port) {
            this.port = port;
            return this;
        }

        public HeartbeatMsgBuilder addressInfos(List<AddressInfo> addressInfos) {
            this.addressInfos = addressInfos;
            return this;
        }

        public HeartbeatMsgBuilder protocolType(String protocolType) {
            this.protocolType = protocolType;
            return this;
        }

        public HeartbeatMsgBuilder componentType(String componentType) {
            this.componentType = componentType;
            return this;
        }

        public HeartbeatMsgBuilder reportSourceType(String reportSourceType) {
            this.reportSourceType = reportSourceType;
            return this;
        }

        public HeartbeatMsgBuilder reportTime(Long reportTime) {
            this.reportTime = reportTime;
            return this;
        }

        public HeartbeatMsgBuilder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public HeartbeatMsgBuilder clusterTag(String clusterTag) {
            this.clusterTag = clusterTag;
            return this;
        }

        public HeartbeatMsgBuilder nodeGroup(String nodeGroup) {
            this.nodeGroup = nodeGroup;
            return this;
        }

        public HeartbeatMsgBuilder extTag(String extTag) {
            this.extTag = extTag;
            return this;
        }

        public HeartbeatMsgBuilder inCharges(String inCharges) {
            this.inCharges = inCharges;
            return this;
        }

        public HeartbeatMsgBuilder groupHeartbeats(List<GroupHeartbeat> groupHeartbeats) {
            this.groupHeartbeats = groupHeartbeats;
            return this;
        }

        public HeartbeatMsgBuilder streamHeartbeats(List<StreamHeartbeat> streamHeartbeats) {
            this.streamHeartbeats = streamHeartbeats;
            return this;
        }

        public HeartbeatMsgBuilder load(Integer load) {
            this.load = load;
            return this;
        }

        public HeartbeatMsg build() {
            return new HeartbeatMsg(this.nodeSrvStatus, this.ip, this.port, this.addressInfos, this.protocolType, this.componentType, this.reportSourceType, this.reportTime, this.clusterName, this.clusterTag, this.nodeGroup, this.extTag, this.inCharges, this.groupHeartbeats, this.streamHeartbeats, this.load);
        }

        public String toString() {
            return "HeartbeatMsg.HeartbeatMsgBuilder(nodeSrvStatus=" + (Object)((Object)this.nodeSrvStatus) + ", ip=" + this.ip + ", port=" + this.port + ", addressInfos=" + this.addressInfos + ", protocolType=" + this.protocolType + ", componentType=" + this.componentType + ", reportSourceType=" + this.reportSourceType + ", reportTime=" + this.reportTime + ", clusterName=" + this.clusterName + ", clusterTag=" + this.clusterTag + ", nodeGroup=" + this.nodeGroup + ", extTag=" + this.extTag + ", inCharges=" + this.inCharges + ", groupHeartbeats=" + this.groupHeartbeats + ", streamHeartbeats=" + this.streamHeartbeats + ", load=" + this.load + ")";
        }
    }
}

