/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.LocalAddress;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.blocks.LazyRemovalCache;
import org.jgroups.protocols.TCP;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.BoundedList;
import org.jgroups.util.Buffer;
import org.jgroups.util.ByteArrayDataInputStream;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.Promise;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

@MBean(description="Failure detection protocol based on sockets connecting members")
public class FD_SOCK
extends Protocol
implements Runnable {
    protected static final int NORMAL_TERMINATION = 9;
    protected static final int ABNORMAL_TERMINATION = -1;
    @LocalAddress
    @Property(description="The NIC on which the ServerSocket should listen on. The following special values are also recognized: GLOBAL, SITE_LOCAL, LINK_LOCAL and NON_LOOPBACK", systemProperty={"jgroups.bind_addr"}, writable=false)
    protected InetAddress bind_addr;
    @Property(description="Use \"external_addr\" if you have hosts on different networks, behind firewalls. On each firewall, set up a port forwarding rule (sometimes called \"virtual server\") to the local IP (e.g. 192.168.1.100) of the host then on each host, set \"external_addr\" TCP transport parameter to the external (public IP) address of the firewall.", systemProperty={"jgroups.external_addr"}, writable=false)
    protected InetAddress external_addr;
    @Property(description="Used to map the internal port (bind_port) to an external port. Only used if > 0", systemProperty={"jgroups.external_port"}, writable=false)
    protected int external_port;
    @Property(description="Timeout for getting socket cache from coordinator")
    protected long get_cache_timeout = 1000L;
    @Property(description="Max number of elements in the cache until deleted elements are removed")
    protected int cache_max_elements = 200;
    @Property(description="Max age (in ms) an element marked as removed has to have until it is removed")
    protected long cache_max_age = 10000L;
    @Property(description="Interval for broadcasting suspect messages")
    protected long suspect_msg_interval = 5000L;
    @Property(description="Number of attempts coordinator is solicited for socket cache until we give up")
    protected int num_tries = 3;
    @Property(description="Start port for server socket. Default value of 0 picks a random port")
    protected int start_port;
    @Property(description="Start port for client socket. Default value of 0 picks a random port")
    protected int client_bind_port;
    @Property(description="Number of ports to probe for start_port and client_bind_port")
    protected int port_range = 50;
    @Property(description="Whether to use KEEP_ALIVE on the ping socket or not. Default is true")
    protected boolean keep_alive = true;
    @Property(description="Max time in millis to wait for ping Socket.connect() to return")
    protected int sock_conn_timeout = 1000;
    protected int num_suspect_events;
    protected final BoundedList<String> suspect_history = new BoundedList(20);
    protected volatile List<Address> members = new ArrayList<Address>(11);
    protected final Set<Address> suspected_mbrs = new ConcurrentSkipListSet<Address>();
    protected final List<Address> pingable_mbrs = new ArrayList<Address>();
    protected volatile boolean srv_sock_sent;
    protected final Promise<Map<Address, IpAddress>> get_cache_promise = new Promise();
    protected volatile boolean got_cache_from_coord;
    protected Address local_addr;
    protected ServerSocket srv_sock;
    protected ServerSocketHandler srv_sock_handler;
    protected IpAddress srv_sock_addr;
    protected Address ping_dest;
    protected Socket ping_sock;
    protected InputStream ping_input;
    protected volatile Thread pinger_thread;
    protected LazyRemovalCache<Address, IpAddress> cache;
    protected final Promise<IpAddress> ping_addr_promise = new Promise();
    protected final Lock lock = new ReentrantLock();
    protected TimeScheduler timer;
    protected final BroadcastTask bcast_task = new BroadcastTask();
    protected volatile boolean regular_sock_close;
    protected volatile boolean shuttin_down;
    protected boolean log_suspected_msgs = true;

    @ManagedAttribute(description="Member address")
    public String getLocalAddress() {
        return this.local_addr != null ? this.local_addr.toString() : "null";
    }

    @ManagedAttribute(description="List of cluster members")
    public String getMembers() {
        return Util.printListWithDelimiter(this.members, ",");
    }

    @ManagedAttribute(description="List of pingable members of a cluster")
    public String getPingableMembers() {
        return this.printPingableMembers();
    }

    @ManagedAttribute(description="List of currently suspected members")
    public String getSuspectedMembers() {
        return this.suspected_mbrs.toString();
    }

    @ManagedAttribute(description="The number of currently suspected members")
    public int getNumSuspectedMembers() {
        return this.suspected_mbrs.size();
    }

    @ManagedAttribute(description="Ping destination")
    public String getPingDest() {
        return this.ping_dest != null ? this.ping_dest.toString() : "null";
    }

    @ManagedAttribute(description="Number of suspect event generated")
    public int getNumSuspectEventsGenerated() {
        return this.num_suspect_events;
    }

    @ManagedAttribute(description="Whether the node crash detection monitor is running")
    public boolean isNodeCrashMonitorRunning() {
        return this.isPingerThreadRunning();
    }

    @ManagedAttribute(description="Whether or not to log suspect messages")
    public boolean isLogSuspectedMessages() {
        return this.log_suspected_msgs;
    }

    public void setLogSuspectedMessages(boolean log_suspected_msgs) {
        this.log_suspected_msgs = log_suspected_msgs;
    }

    @ManagedAttribute(description="The actual client_bind_port")
    public int getClientBindPortActual() {
        return this.ping_sock != null ? this.ping_sock.getLocalPort() : 0;
    }

    @ManagedOperation(description="Print suspect history")
    public String printSuspectHistory() {
        StringBuilder sb = new StringBuilder();
        for (String suspect : this.suspect_history) {
            sb.append(suspect).append("\n");
        }
        return sb.toString();
    }

    @ManagedOperation
    public String printCache() {
        return this.cache.printCache();
    }

    @ManagedOperation(description="Starts node crash monitor if member count > 1 and monitor is not running")
    public boolean startNodeCrashMonitor() {
        if (this.members.size() > 1) {
            if (this.startPingerThread()) {
                this.log.warn("Node crash detection manually started, was not running for some reason.");
                return true;
            }
            this.log.debug("Node crash detection is already running.");
        } else {
            this.log.debug("Single node cluster, no need for node crash detection.");
        }
        return false;
    }

    @Override
    public void init() throws Exception {
        this.cache = new LazyRemovalCache(this.cache_max_elements, this.cache_max_age);
        this.shuttin_down = false;
        this.srv_sock_handler = new ServerSocketHandler();
    }

    @Override
    public void start() throws Exception {
        this.shuttin_down = false;
        super.start();
        this.timer = this.getTransport().getTimer();
        if (this.timer == null) {
            throw new Exception("timer is null");
        }
    }

    @Override
    public void stop() {
        this.shuttin_down = true;
        this.resetPingableMembers(null);
        this.stopPingerThread();
        this.stopServerSocket(true);
        this.bcast_task.removeAll();
        this.suspected_mbrs.clear();
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_suspect_events = 0;
        this.suspect_history.clear();
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 56: {
                Object val;
                Map config = (Map)evt.getArg();
                if (this.bind_addr == null) {
                    this.bind_addr = (InetAddress)config.get("bind_addr");
                }
                if (this.external_addr == null) {
                    this.external_addr = (InetAddress)config.get("external_addr");
                }
                if (this.external_port > 0 || (val = config.get("external_port")) == null) break;
                this.external_port = (Integer)val;
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object up(Message msg) {
        FdHeader hdr = (FdHeader)msg.getHeader(this.id);
        if (hdr == null) {
            return this.up_prot.up(msg);
        }
        switch (hdr.type) {
            case 10: {
                if (hdr.mbrs == null) break;
                this.log.trace("%s: received SUSPECT message from %s: suspects=%s", this.local_addr, msg.getSrc(), hdr.mbrs);
                this.suspect(hdr.mbrs);
                break;
            }
            case 11: {
                if (hdr.mbrs == null) break;
                this.log.trace("%s: received UNSUSPECT message from %s: mbrs=%s", this.local_addr, msg.getSrc(), hdr.mbrs);
                hdr.mbrs.forEach(this::unsuspect);
                break;
            }
            case 12: {
                if (Objects.equals(this.local_addr, msg.getSrc())) {
                    return null;
                }
                if (hdr.mbr == null) {
                    return null;
                }
                this.log.trace("%s: who-has-sock %s", this.local_addr, hdr.mbr);
                if (this.local_addr != null && this.local_addr.equals(hdr.mbr) && this.srv_sock_addr != null) {
                    this.sendIHaveSockMessage(msg.getSrc(), this.local_addr, this.srv_sock_addr);
                    return null;
                }
                IpAddress addr = this.cache.get(hdr.mbr);
                if (addr == null) break;
                this.sendIHaveSockMessage(msg.getSrc(), hdr.mbr, addr);
                break;
            }
            case 13: {
                if (hdr.mbr == null || hdr.sock_addr == null) {
                    return null;
                }
                this.cache.add(hdr.mbr, hdr.sock_addr);
                this.log.trace("%s: i-have-sock: %s --> %s (cache is %s)", this.local_addr, hdr.mbr, hdr.sock_addr, this.cache);
                if (!hdr.mbr.equals(this.ping_dest)) break;
                this.ping_addr_promise.setResult(hdr.sock_addr);
                break;
            }
            case 14: {
                msg = new Message(msg.getSrc()).setFlag(Message.Flag.INTERNAL).putHeader(this.id, new FdHeader(15)).setBuffer(FD_SOCK.marshal(this.cache));
                this.down_prot.down(msg);
                break;
            }
            case 15: {
                Map<Address, IpAddress> cachedAddrs = this.unmarshal(msg.getRawBuffer(), msg.getOffset(), msg.getLength());
                if (cachedAddrs == null) break;
                this.get_cache_promise.setResult(cachedAddrs);
            }
        }
        return null;
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 51: {
                this.broadcastUnuspectMessage((Address)evt.getArg());
                break;
            }
            case 2: 
            case 80: 
            case 92: 
            case 93: {
                this.shuttin_down = false;
                Object ret = this.down_prot.down(evt);
                try {
                    this.startServerSocket();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("failed to start server socket", e);
                }
                return ret;
            }
            case 4: {
                this.shuttin_down = true;
                this.stopServerSocket(true);
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 6: {
                View v = (View)evt.getArg();
                List<Address> new_mbrs = v.getMembers();
                this.members = new_mbrs;
                this.suspected_mbrs.retainAll(new_mbrs);
                this.cache.keySet().retainAll(new_mbrs);
                this.bcast_task.adjustSuspectedMembers(new_mbrs);
                this.resetPingableMembers(new_mbrs);
                if (new_mbrs.size() > 1) {
                    boolean hasNewPingDest;
                    Address tmp_ping_dest = this.determinePingDest();
                    boolean bl = hasNewPingDest = tmp_ping_dest != null && !tmp_ping_dest.equals(this.ping_dest);
                    if (!hasNewPingDest) break;
                    this.interruptPingerThread(false);
                    this.startPingerThread();
                    break;
                }
                this.ping_dest = null;
                this.stopPingerThread();
                break;
            }
            default: {
                return this.down_prot.down(evt);
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public void run() {
        if (!this.srv_sock_sent && this.srv_sock_addr != null) {
            this.sendIHaveSockMessage(null, this.local_addr, this.srv_sock_addr);
            this.srv_sock_sent = true;
        }
        if (!this.got_cache_from_coord) {
            this.getCacheFromCoordinator();
            this.got_cache_from_coord = true;
        }
        this.log.trace("%s: pinger_thread started", this.local_addr);
        while (this.hasPingableMembers()) {
            this.regular_sock_close = false;
            this.ping_dest = this.determinePingDest();
            if (this.ping_dest == null || !this.isPingerThreadRunning()) break;
            this.log.debug("%s: pingable_mbrs=%s, ping_dest=%s", this.local_addr, this.printPingableMembers(), this.ping_dest);
            IpAddress ping_addr = this.fetchPingAddress(this.ping_dest);
            if (ping_addr == null) {
                this.log.trace("%s: socket address for %s could not be fetched, retrying", this.local_addr, this.ping_dest);
                Util.sleep(1000L);
                continue;
            }
            if (!this.setupPingSocket(ping_addr) && this.isPingerThreadRunning()) {
                this.broadcastSuspectMessage(this.ping_dest);
                this.removeFromPingableMembers(this.ping_dest);
                continue;
            }
            this.log.trace("%s: ping_dest=%s, ping_sock=%s, cache=%s", this.local_addr, this.ping_dest, this.ping_sock, this.cache);
            try {
                if (this.ping_input == null) continue;
                int c = this.ping_input.read();
                switch (c) {
                    case 9: {
                        this.log.debug("%s: %s closed socket gracefully", this.local_addr, this.ping_dest);
                        this.removeFromPingableMembers(this.ping_dest);
                        break;
                    }
                    case -1: {
                        this.handleSocketClose(null);
                        break;
                    }
                }
            }
            catch (IOException ex) {
                this.handleSocketClose(ex);
            }
            catch (Throwable catch_all_the_rest) {
                this.log.error("exception", catch_all_the_rest);
            }
        }
        this.log.trace("%s: pinger thread terminated", this.local_addr);
    }

    protected synchronized boolean isPingerThreadRunning() {
        return this.pinger_thread != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetPingableMembers(Collection<Address> new_mbrs) {
        List<Address> list = this.pingable_mbrs;
        synchronized (list) {
            this.pingable_mbrs.clear();
            if (new_mbrs != null) {
                this.pingable_mbrs.addAll(new_mbrs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasPingableMembers() {
        List<Address> list = this.pingable_mbrs;
        synchronized (list) {
            return !this.pingable_mbrs.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeFromPingableMembers(Address mbr) {
        if (mbr == null) {
            return false;
        }
        List<Address> list = this.pingable_mbrs;
        synchronized (list) {
            return this.pingable_mbrs.remove(mbr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String printPingableMembers() {
        List<Address> list = this.pingable_mbrs;
        synchronized (list) {
            return this.pingable_mbrs.toString();
        }
    }

    protected void suspect(Set<Address> suspects) {
        if (suspects == null) {
            return;
        }
        suspects.remove(this.local_addr);
        suspects.forEach(suspect -> this.suspect_history.add(String.format("%s: %s", new Date(), suspect)));
        this.suspected_mbrs.addAll(suspects);
        ArrayList<Address> eligible_mbrs = new ArrayList<Address>(this.members);
        eligible_mbrs.removeAll(this.suspected_mbrs);
        if (this.local_addr != null && !eligible_mbrs.isEmpty() && this.local_addr.equals(eligible_mbrs.get(0))) {
            this.log.debug("%s: suspecting %s", this.local_addr, this.suspected_mbrs);
            this.up_prot.up(new Event(9, this.suspected_mbrs));
            this.down_prot.down(new Event(9, this.suspected_mbrs));
        }
    }

    protected void unsuspect(Address mbr) {
        if (mbr == null) {
            return;
        }
        this.suspected_mbrs.remove(mbr);
        this.bcast_task.removeSuspectedMember(mbr);
    }

    protected void handleSocketClose(Exception ex) {
        this.teardownPingSocket();
        if (!this.regular_sock_close) {
            this.log.debug("%s: %s closed socket (%s)", this.local_addr, this.ping_dest, ex != null ? ex.toString() : "eof");
            this.broadcastSuspectMessage(this.ping_dest);
            this.removeFromPingableMembers(this.ping_dest);
        } else {
            this.log.debug("%s: socket to %s was closed gracefully", this.local_addr, this.ping_dest);
            this.regular_sock_close = false;
        }
    }

    protected synchronized boolean startPingerThread() {
        if (!this.isPingerThreadRunning()) {
            ThreadFactory factory = this.getThreadFactory();
            this.pinger_thread = factory.newThread(this, "FD_SOCK pinger");
            this.pinger_thread.setDaemon(true);
            this.pinger_thread.start();
            return true;
        }
        return false;
    }

    protected synchronized void interruptPingerThread(boolean sendTerminationSignal) {
        if (this.isPingerThreadRunning()) {
            this.regular_sock_close = true;
            if (sendTerminationSignal) {
                this.sendPingTermination();
            }
            this.teardownPingSocket();
        }
    }

    protected synchronized void stopPingerThread() {
        this.ping_addr_promise.setResult(null);
        this.get_cache_promise.setResult(null);
        this.interruptPingerThread(true);
        if (this.pinger_thread != null) {
            try {
                this.pinger_thread.join(300L);
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
            this.pinger_thread = null;
        }
    }

    protected void sendPingTermination() {
        this.sendPingSignal(9);
    }

    protected void sendPingSignal(int signal) {
        this.lock.lock();
        try {
            if (this.ping_sock != null) {
                OutputStream out = this.ping_sock.getOutputStream();
                out.write(signal);
                out.flush();
            }
        }
        catch (Throwable t) {
            this.log.trace("%s: problem sending signal %s: %s", this.local_addr, FD_SOCK.signalToString(signal), t);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void startServerSocket() throws Exception {
        this.srv_sock = Util.createServerSocket(this.getSocketFactory(), "jgroups.fd_sock.srv_sock", this.bind_addr, this.start_port, this.start_port + this.port_range);
        this.srv_sock_addr = new IpAddress(this.external_addr != null ? this.external_addr : this.bind_addr, this.external_port > 0 ? this.external_port : this.srv_sock.getLocalPort());
        if (this.local_addr != null) {
            this.cache.add(this.local_addr, this.srv_sock_addr);
        }
        if (this.srv_sock_handler != null) {
            this.srv_sock_handler.start();
        }
    }

    public void stopServerSocket(boolean graceful) {
        if (this.srv_sock_handler != null) {
            this.srv_sock_handler.stop(graceful);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setupPingSocket(IpAddress dest) {
        this.lock.lock();
        try {
            InetSocketAddress destAddr = new InetSocketAddress(dest.getIpAddress(), dest.getPort());
            this.ping_sock = this.getSocketFactory().createSocket("jgroups.fd.ping_sock");
            Util.bind(this.ping_sock, this.bind_addr, this.client_bind_port, this.client_bind_port + this.port_range);
            this.ping_sock.setSoLinger(true, 1);
            this.ping_sock.setKeepAlive(this.keep_alive);
            Util.connect(this.ping_sock, destAddr, this.sock_conn_timeout);
            this.ping_input = this.ping_sock.getInputStream();
            boolean bl = true;
            return bl;
        }
        catch (Throwable ex) {
            if (!this.shuttin_down) {
                this.log.debug("%s: failed connecting to %s: %s", this.local_addr, this.ping_dest != null ? this.ping_dest : dest, ex.getMessage());
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void teardownPingSocket() {
        this.lock.lock();
        try {
            if (this.ping_sock != null) {
                try {
                    this.ping_sock.shutdownInput();
                    this.ping_sock.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Util.close((Closeable)this.ping_input);
        }
        finally {
            this.ping_sock = null;
            this.ping_input = null;
            this.lock.unlock();
        }
    }

    protected void getCacheFromCoordinator() {
        this.get_cache_promise.reset();
        for (int attempts = this.num_tries; attempts > 0 && this.isPingerThreadRunning(); --attempts) {
            Address coord = this.determineCoordinator();
            if (coord == null) continue;
            if (coord.equals(this.local_addr)) {
                return;
            }
            Message msg = new Message(coord).setFlag(Message.Flag.INTERNAL).putHeader(this.id, new FdHeader(14));
            this.down_prot.down(msg);
            Map<Address, IpAddress> result = this.get_cache_promise.getResult(this.get_cache_timeout);
            if (result == null) continue;
            this.cache.addAll(result);
            this.log.trace("%s: got cache from %s: cache is %s", this.local_addr, coord, this.cache);
            return;
        }
    }

    protected void broadcastSuspectMessage(Address suspected_mbr) {
        if (suspected_mbr == null) {
            return;
        }
        this.log.debug("%s: broadcasting suspect(%s)", this.local_addr, suspected_mbr);
        FdHeader hdr = new FdHeader(10).mbrs(Collections.singleton(suspected_mbr));
        Message suspect_msg = new Message().setFlag(Message.Flag.INTERNAL).putHeader(this.id, hdr);
        this.down_prot.down(suspect_msg);
        this.bcast_task.addSuspectedMember(suspected_mbr);
        if (this.stats) {
            ++this.num_suspect_events;
            this.suspect_history.add(String.format("%s: %s", new Date(), suspected_mbr));
        }
    }

    protected void broadcastUnuspectMessage(Address mbr) {
        if (mbr == null) {
            return;
        }
        this.log.debug("%s: broadcasting unsuspect(%s)", this.local_addr, mbr);
        FdHeader hdr = new FdHeader(11).mbrs(Collections.singleton(mbr));
        Message suspect_msg = new Message().setFlag(Message.Flag.INTERNAL).putHeader(this.id, hdr);
        this.down_prot.down(suspect_msg);
    }

    protected void sendIHaveSockMessage(Address dst, Address mbr, IpAddress addr) {
        Message msg = new Message(dst).setFlag(Message.Flag.INTERNAL).setTransientFlag(Message.TransientFlag.DONT_LOOPBACK);
        FdHeader hdr = new FdHeader(13, mbr).sockAddress(addr);
        msg.putHeader(this.id, hdr);
        this.down_prot.down(msg);
    }

    protected IpAddress fetchPingAddress(Address mbr) {
        if (mbr == null) {
            return null;
        }
        IpAddress ret = this.cache.get(mbr);
        if (ret != null) {
            return ret;
        }
        if (!this.isPingerThreadRunning()) {
            return null;
        }
        this.ping_addr_promise.reset();
        for (Address dest : Arrays.asList(mbr, null)) {
            Message msg = new Message(dest).setFlag(Message.Flag.INTERNAL).setTransientFlag(Message.TransientFlag.DONT_LOOPBACK).putHeader(this.id, new FdHeader(12, mbr));
            this.down_prot.down(msg);
            ret = this.ping_addr_promise.getResult(500L);
            if (ret != null) {
                return ret;
            }
            if (this.isPingerThreadRunning()) continue;
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Address determinePingDest() {
        Address next;
        if (this.local_addr == null) {
            return null;
        }
        List<Address> list = this.pingable_mbrs;
        synchronized (list) {
            next = Util.pickNext(this.pingable_mbrs, this.local_addr);
        }
        return Objects.equals(this.local_addr, next) ? null : next;
    }

    public static Buffer marshal(LazyRemovalCache<Address, IpAddress> addrs) {
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(512);
        try {
            int size = addrs != null ? addrs.size() : 0;
            out.writeInt(size);
            if (size > 0) {
                for (Map.Entry<Address, LazyRemovalCache.Entry<IpAddress>> entry : addrs.entrySet()) {
                    Address key = entry.getKey();
                    IpAddress val = entry.getValue().getVal();
                    Util.writeAddress(key, out);
                    Util.writeStreamable(val, out);
                }
            }
            return out.getBuffer();
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected Map<Address, IpAddress> unmarshal(byte[] buffer, int offset, int length) {
        if (buffer == null) {
            return null;
        }
        ByteArrayDataInputStream in = new ByteArrayDataInputStream(buffer, offset, length);
        HashMap<Address, IpAddress> addrs = null;
        try {
            int size = in.readInt();
            if (size > 0) {
                addrs = new HashMap<Address, IpAddress>(size);
                for (int i = 0; i < size; ++i) {
                    Address key = Util.readAddress(in);
                    IpAddress val = Util.readStreamable(IpAddress::new, in);
                    addrs.put(key, val);
                }
            }
            return addrs;
        }
        catch (Exception ex) {
            this.log.error("%s: failed reading addresses from message: %s", this.local_addr, ex);
            return null;
        }
    }

    protected Address determineCoordinator() {
        List<Address> tmp = this.members;
        return !tmp.isEmpty() ? tmp.get(0) : null;
    }

    protected static String signalToString(int signal) {
        switch (signal) {
            case 9: {
                return "NORMAL_TERMINATION";
            }
            case -1: {
                return "ABNORMAL_TERMINATION";
            }
        }
        return "n/a";
    }

    protected class BroadcastTask
    implements Runnable {
        protected final Set<Address> suspects = new HashSet<Address>();
        protected Future<?> future;

        protected BroadcastTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addSuspectedMember(Address mbr) {
            if (mbr == null) {
                return;
            }
            if (!FD_SOCK.this.members.contains(mbr)) {
                return;
            }
            Set<Address> set = this.suspects;
            synchronized (set) {
                if (this.suspects.add(mbr)) {
                    this.startTask();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeSuspectedMember(Address suspected_mbr) {
            if (suspected_mbr == null) {
                return;
            }
            Set<Address> set = this.suspects;
            synchronized (set) {
                if (this.suspects.remove(suspected_mbr) && this.suspects.isEmpty()) {
                    this.stopTask();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeAll() {
            Set<Address> set = this.suspects;
            synchronized (set) {
                this.suspects.clear();
                this.stopTask();
            }
        }

        protected void startTask() {
            if (this.future == null || this.future.isDone()) {
                try {
                    this.future = FD_SOCK.this.timer.scheduleWithFixedDelay(this, FD_SOCK.this.suspect_msg_interval, FD_SOCK.this.suspect_msg_interval, TimeUnit.MILLISECONDS, FD_SOCK.this.getTransport() instanceof TCP);
                }
                catch (RejectedExecutionException e) {
                    FD_SOCK.this.log.warn("%s: task %s was rejected as timer thread pool is shutting down", FD_SOCK.this.local_addr, this);
                }
            }
        }

        protected void stopTask() {
            if (this.future != null) {
                this.future.cancel(false);
                this.future = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void adjustSuspectedMembers(List<Address> new_mbrship) {
            if (new_mbrship == null || new_mbrship.isEmpty()) {
                return;
            }
            Set<Address> set = this.suspects;
            synchronized (set) {
                boolean modified = this.suspects.retainAll(new_mbrship);
                if (modified) {
                    FD_SOCK.this.log.trace("%s: adjusted suspected_mbrs: %s", FD_SOCK.this.local_addr, this.suspects);
                }
                if (this.suspects.isEmpty()) {
                    this.stopTask();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FdHeader hdr;
            FD_SOCK.this.log.trace("%s: broadcasting SUSPECT message (suspected_mbrs=%s)", FD_SOCK.this.local_addr, this.suspects);
            Set<Address> set = this.suspects;
            synchronized (set) {
                if (this.suspects.isEmpty()) {
                    this.stopTask();
                    return;
                }
                hdr = new FdHeader(10).mbrs(new HashSet<Address>(this.suspects));
            }
            Message suspect_msg = new Message().setFlag(Message.Flag.INTERNAL).putHeader(FD_SOCK.this.id, hdr);
            FD_SOCK.this.down_prot.down(suspect_msg);
        }

        public String toString() {
            return FD_SOCK.class.getSimpleName() + ": " + this.getClass().getSimpleName();
        }
    }

    protected static class ClientConnectionHandler
    implements Runnable {
        Socket client_sock;
        InputStream in;
        final List<ClientConnectionHandler> clients;

        protected ClientConnectionHandler(Socket client_sock, List<ClientConnectionHandler> clients) {
            this.client_sock = client_sock;
            this.clients = clients;
        }

        protected synchronized void stopThread(boolean graceful) {
            if (this.client_sock != null) {
                try {
                    if (graceful) {
                        OutputStream out = this.client_sock.getOutputStream();
                        out.write(9);
                        out.flush();
                    }
                    Util.close((Closeable)this.client_sock);
                    this.client_sock = null;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int b;
                ClientConnectionHandler clientConnectionHandler = this;
                synchronized (clientConnectionHandler) {
                    block24: {
                        if (this.client_sock != null) break block24;
                        return;
                    }
                    this.in = this.client_sock.getInputStream();
                }
                while ((b = this.in.read()) != -1 && b != 9) {
                }
            }
            catch (IOException sock) {
                Socket sock2 = this.client_sock;
                if (sock2 != null && !sock2.isClosed()) {
                    Util.close((Closeable)sock2);
                    this.client_sock = null;
                }
                List<ClientConnectionHandler> list = this.clients;
                synchronized (list) {
                    this.clients.remove(this);
                }
            }
            finally {
                Socket sock = this.client_sock;
                if (sock != null && !sock.isClosed()) {
                    Util.close((Closeable)sock);
                    this.client_sock = null;
                }
                List<ClientConnectionHandler> list = this.clients;
                synchronized (list) {
                    this.clients.remove(this);
                }
            }
        }
    }

    protected class ServerSocketHandler
    implements Runnable {
        protected Thread acceptor;
        protected final List<ClientConnectionHandler> clients = new LinkedList<ClientConnectionHandler>();

        protected String getName() {
            return this.acceptor != null ? this.acceptor.getName() : null;
        }

        protected ServerSocketHandler() {
            this.start();
        }

        protected void start() {
            if (this.acceptor == null) {
                this.acceptor = FD_SOCK.this.getThreadFactory().newThread(this, "FD_SOCK acceptor");
                this.acceptor.setDaemon(true);
                this.acceptor.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void stop(boolean graceful) {
            if (this.acceptor != null && this.acceptor.isAlive()) {
                Util.close((Closeable)FD_SOCK.this.srv_sock);
            }
            List<ClientConnectionHandler> list = this.clients;
            synchronized (list) {
                this.clients.forEach(client -> client.stopThread(graceful));
                this.clients.clear();
            }
            this.acceptor = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.acceptor != null && FD_SOCK.this.srv_sock != null) {
                try {
                    Socket client_sock = FD_SOCK.this.srv_sock.accept();
                    FD_SOCK.this.log.trace("%s: accepted connection from %s:%s", FD_SOCK.this.local_addr, client_sock.getInetAddress(), client_sock.getPort());
                    client_sock.setKeepAlive(FD_SOCK.this.keep_alive);
                    ClientConnectionHandler client_conn_handler = new ClientConnectionHandler(client_sock, this.clients);
                    ThreadFactory factory = FD_SOCK.this.getThreadFactory();
                    Thread t = factory != null ? factory.newThread(client_conn_handler, "FD_SOCK conn-handler") : new Thread((Runnable)client_conn_handler, "FD_SOCK conn-handler");
                    t.setDaemon(true);
                    List<ClientConnectionHandler> list = this.clients;
                    synchronized (list) {
                        this.clients.add(client_conn_handler);
                    }
                    t.start();
                }
                catch (IOException io_ex2) {
                    // empty catch block
                    break;
                }
            }
            this.acceptor = null;
        }
    }

    public static class FdHeader
    extends Header {
        public static final byte SUSPECT = 10;
        public static final byte UNSUSPECT = 11;
        public static final byte WHO_HAS_SOCK = 12;
        public static final byte I_HAVE_SOCK = 13;
        public static final byte GET_CACHE = 14;
        public static final byte GET_CACHE_RSP = 15;
        protected byte type = (byte)10;
        protected Address mbr;
        protected IpAddress sock_addr;
        protected Set<Address> mbrs;

        public FdHeader() {
        }

        public FdHeader(byte type) {
            this.type = type;
        }

        public FdHeader(byte type, Address mbr) {
            this.type = type;
            this.mbr = mbr;
        }

        public FdHeader(byte type, Address mbr, IpAddress sock_addr) {
            this.type = type;
            this.mbr = mbr;
            this.sock_addr = sock_addr;
        }

        @Override
        public short getMagicId() {
            return 51;
        }

        @Override
        public Supplier<? extends Header> create() {
            return FdHeader::new;
        }

        public FdHeader mbrs(Set<Address> members) {
            this.mbrs = members;
            return this;
        }

        public FdHeader sockAddress(IpAddress a) {
            this.sock_addr = a;
            return this;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(FdHeader.type2String(this.type));
            if (this.mbr != null) {
                sb.append(", mbr=").append(this.mbr);
            }
            if (this.sock_addr != null) {
                sb.append(", sock_addr=").append(this.sock_addr);
            }
            if (this.mbrs != null) {
                sb.append(", mbrs=").append(this.mbrs);
            }
            return sb.toString();
        }

        public static String type2String(byte type) {
            switch (type) {
                case 10: {
                    return "SUSPECT";
                }
                case 11: {
                    return "UNSUSPECT";
                }
                case 12: {
                    return "WHO_HAS_SOCK";
                }
                case 13: {
                    return "I_HAVE_SOCK";
                }
                case 14: {
                    return "GET_CACHE";
                }
                case 15: {
                    return "GET_CACHE_RSP";
                }
            }
            return "unknown type (" + type + ')';
        }

        @Override
        public int serializedSize() {
            int retval = 1;
            retval += Util.size(this.mbr);
            int ipaddr_size = 0;
            ++ipaddr_size;
            if (this.sock_addr != null) {
                ipaddr_size += this.sock_addr.serializedSize();
            }
            retval += ipaddr_size;
            retval += 4;
            if (this.mbrs != null) {
                for (Address m : this.mbrs) {
                    retval += Util.size(m);
                }
            }
            return retval;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            out.writeByte(this.type);
            Util.writeAddress(this.mbr, out);
            Util.writeStreamable(this.sock_addr, out);
            int size = this.mbrs != null ? this.mbrs.size() : 0;
            out.writeInt(size);
            if (size > 0) {
                for (Address address : this.mbrs) {
                    Util.writeAddress(address, out);
                }
            }
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
            this.mbr = Util.readAddress(in);
            this.sock_addr = Util.readStreamable(IpAddress::new, in);
            int size = in.readInt();
            if (size > 0) {
                this.mbrs = new HashSet<Address>();
                for (int i = 0; i < size; ++i) {
                    this.mbrs.add(Util.readAddress(in));
                }
            }
        }
    }
}

