/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.inlongmsg;

import org.apache.inlong.common.pojo.sort.dataflow.field.format.FormatInfo;
import org.apache.inlong.sort.formats.inlongmsg.FailureHandler;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgBody;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgHead;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgnoreFailureHandler
implements FailureHandler {
    private static final Logger LOG = LoggerFactory.getLogger(IgnoreFailureHandler.class);

    @Override
    public void onParsingMsgFailure(Object msg, Exception exception) {
        LOG.error("Could not properly deserialize msg=[{}].", msg, (Object)exception);
    }

    @Override
    public void onParsingHeadFailure(String attribute, Exception exception) {
        LOG.warn("Cannot properly parse the head {}", (Object)attribute, (Object)exception);
    }

    @Override
    public void onParsingBodyFailure(InLongMsgHead head, byte[] body, Exception exception) {
        LOG.warn("Cannot properly parse the head: {}, body: {}.", new Object[]{head, new String(body), exception});
    }

    @Override
    public void onConvertingRowFailure(InLongMsgHead head, InLongMsgBody body, Exception exception) {
        LOG.warn("Cannot properly convert the InLongMsg ({}, {})", new Object[]{head, body, exception});
    }

    @Override
    public void onConvertingFieldFailure(String fieldName, String fieldText, FormatInfo formatInfo, Exception exception) throws Exception {
        LOG.warn("Cannot convert the InLongMsg Filed (fieldName = {}, formatInfo = {}, fieldText = {}),", new Object[]{fieldName, formatInfo, fieldText, exception});
    }

    @Override
    public boolean isIgnoreFailure() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }
}

