/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.message;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.common.util.SnowFlake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequentialID {
    private static final Logger LOGGER = LoggerFactory.getLogger(SequentialID.class);
    private static SequentialID uniqueSequentialID = null;
    private SnowFlake snowFlake;

    private SequentialID() {
        long machineId = this.ipStr2Int(AgentUtils.getLocalIp());
        this.snowFlake = new SnowFlake(machineId);
    }

    private long ipStr2Int(String ip) {
        InetAddress ipv;
        long result = 0L;
        try {
            ipv = InetAddress.getByName(ip);
        }
        catch (UnknownHostException e) {
            LOGGER.error("convert ip to int error", (Throwable)e);
            return AgentUtils.getRandomBySeed((int)10);
        }
        for (byte b : ipv.getAddress()) {
            result = result << 8 | (long)(b & 0xFF);
        }
        if (result < 0L) {
            result = AgentUtils.getRandomBySeed((int)10);
        }
        if (result > 8191L) {
            result %= 8191L;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized SequentialID getInstance() {
        if (uniqueSequentialID != null) return uniqueSequentialID;
        Class<SequentialID> clazz = SequentialID.class;
        synchronized (SequentialID.class) {
            if (uniqueSequentialID != null) return uniqueSequentialID;
            uniqueSequentialID = new SequentialID();
            // ** MonitorExit[var0] (shouldn't be in output)
            return uniqueSequentialID;
        }
    }

    public String getNextUuid() {
        return String.valueOf(this.snowFlake.nextId());
    }
}

