/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.instance;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.core.instance.ActionType;
import org.apache.inlong.agent.core.instance.InstanceAction;
import org.apache.inlong.agent.core.instance.InstanceManager;
import org.apache.inlong.agent.core.task.OffsetManager;
import org.apache.inlong.agent.metrics.audit.AuditUtils;
import org.apache.inlong.agent.plugin.Instance;
import org.apache.inlong.agent.plugin.Message;
import org.apache.inlong.agent.plugin.file.Sink;
import org.apache.inlong.agent.plugin.file.Source;
import org.apache.inlong.agent.state.State;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.ThreadUtils;
import org.apache.inlong.common.enums.InstanceStateEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonInstance
extends Instance {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonInstance.class);
    public static final int HEARTBEAT_CHECK_GAP = 10;
    private Source source;
    private Sink sink;
    private InstanceProfile profile;
    public static final int CORE_THREAD_SLEEP_TIME = 10;
    private static final int DESTROY_LOOP_WAIT_TIME_MS = 10;
    private static final int CHECK_FINISH_AT_LEAST_COUNT = 5;
    private final int WRITE_FAILED_WAIT_TIME_MS = 10;
    private InstanceManager instanceManager;
    private volatile boolean running = false;
    private volatile boolean inited = false;
    private volatile int checkFinishCount = 0;
    private int heartbeatCheckCount = 0;
    private long heartBeatStartTime = AgentUtils.getCurrentTime();
    protected long auditVersion;

    public boolean init(Object srcManager, InstanceProfile srcProfile) {
        try {
            this.instanceManager = (InstanceManager)srcManager;
            this.profile = srcProfile;
            this.auditVersion = Long.parseLong(srcProfile.get("task.auditVersion"));
            this.setInodeInfo(this.profile);
            LOGGER.info("task id: {} submit new instance {} profile detail {}.", new Object[]{this.profile.getTaskId(), this.profile.getInstanceId(), this.profile.toJsonStr()});
            this.source = (Source)Class.forName(this.profile.getSourceClass()).newInstance();
            this.source.init(this.profile);
            this.sink = (Sink)Class.forName(this.profile.getSinkClass()).newInstance();
            this.sink.init(this.profile);
            this.inited = true;
            return true;
        }
        catch (Throwable e) {
            this.handleDeleted();
            this.doChangeState(State.FATAL);
            LOGGER.error("init instance {} for task {} failed", new Object[]{this.profile.getInstanceId(), this.profile.getInstanceId(), e});
            ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)e);
            return false;
        }
    }

    public abstract void setInodeInfo(InstanceProfile var1) throws IOException;

    public void destroy() {
        Long start = AgentUtils.getCurrentTime();
        this.notifyDestroy();
        while (this.running) {
            AgentUtils.silenceSleepInMs((long)10L);
        }
        LOGGER.info("destroy instance wait run elapse {} ms instance {}", (Object)(AgentUtils.getCurrentTime() - start), (Object)this.profile.getInstanceId());
        start = AgentUtils.getCurrentTime();
        this.source.destroy();
        LOGGER.info("destroy instance wait source elapse {} ms instance {}", (Object)(AgentUtils.getCurrentTime() - start), (Object)this.profile.getInstanceId());
        start = AgentUtils.getCurrentTime();
        this.sink.destroy();
        LOGGER.info("destroy instance wait sink elapse {} ms instance {}", (Object)(AgentUtils.getCurrentTime() - start), (Object)this.profile.getInstanceId());
    }

    public void notifyDestroy() {
        if (!this.inited) {
            return;
        }
        this.doChangeState(State.SUCCEEDED);
    }

    public void run() {
        Thread.currentThread().setName("instance-core-" + this.getTaskId() + "-" + this.getInstanceId());
        this.running = true;
        try {
            this.doRun();
        }
        catch (Throwable e) {
            LOGGER.error("do run error: ", e);
            ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)e);
        }
        this.running = false;
    }

    private void doRun() {
        this.source.start();
        while (!this.isFinished()) {
            if (!this.source.sourceExist()) {
                if (this.handleDeleted()) break;
                LOGGER.error("instance manager action queue is full: taskId {}", (Object)this.instanceManager.getTaskId());
                AgentUtils.silenceSleepInMs((long)10L);
                continue;
            }
            Message msg = this.source.read();
            if (msg == null) {
                if (this.source.sourceFinish() && this.sink.sinkFinish()) {
                    ++this.checkFinishCount;
                    if (this.checkFinishCount > 5) {
                        this.handleReadEnd();
                        break;
                    }
                } else {
                    this.checkFinishCount = 0;
                }
                this.heartbeatStatic();
                AgentUtils.silenceSleepInMs((long)10L);
                continue;
            }
            boolean suc = false;
            while (!this.isFinished() && !suc) {
                suc = this.sink.write(msg);
                if (suc) continue;
                this.heartbeatStatic();
                AgentUtils.silenceSleepInMs((long)10L);
            }
            ++this.heartbeatCheckCount;
            if (this.heartbeatCheckCount <= 10) continue;
            this.heartbeatStatic();
        }
    }

    private void heartbeatStatic() {
        if (AgentUtils.getCurrentTime() - this.heartBeatStartTime > TimeUnit.SECONDS.toMillis(1L)) {
            AuditUtils.add((int)AuditUtils.AUDIT_ID_AGENT_INSTANCE_HEARTBEAT, (String)this.profile.getInlongGroupId(), (String)this.profile.getInlongStreamId(), (long)AgentUtils.getCurrentTime(), (int)1, (long)1L, (long)this.auditVersion);
            this.heartbeatCheckCount = 0;
            this.heartBeatStartTime = AgentUtils.getCurrentTime();
        }
    }

    private void handleReadEnd() {
        while (!this.isFinished() && !this.instanceManager.submitAction(new InstanceAction(ActionType.FINISH, this.profile))) {
            LOGGER.error("instance manager action queue is full: taskId {}", (Object)this.instanceManager.getTaskId());
            AgentUtils.silenceSleepInMs((long)10L);
        }
    }

    private boolean handleDeleted() {
        OffsetManager.getInstance().deleteOffset(this.getTaskId(), this.getInstanceId());
        this.profile.setState(InstanceStateEnum.DELETE);
        this.profile.setModifyTime(Long.valueOf(AgentUtils.getCurrentTime()));
        InstanceAction action = new InstanceAction(ActionType.DELETE, this.profile);
        return this.instanceManager.submitAction(action);
    }

    public long getLastHeartbeatTime() {
        return this.heartBeatStartTime;
    }

    public void addCallbacks() {
    }

    public String getTaskId() {
        return this.profile.getTaskId();
    }

    public String getInstanceId() {
        return this.profile.getInstanceId();
    }

    public Sink getSink() {
        return this.sink;
    }

    public InstanceProfile getProfile() {
        return this.profile;
    }
}

