/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.api;

import java.util.List;
import java.util.Properties;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.FlumeException;
import org.apache.flume.api.RpcClient;
import org.apache.flume.api.RpcClientConfigurationConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRpcClient
implements RpcClient {
    private static Logger logger = LoggerFactory.getLogger(AbstractRpcClient.class);
    protected int batchSize = RpcClientConfigurationConstants.DEFAULT_BATCH_SIZE;
    protected long connectTimeout = RpcClientConfigurationConstants.DEFAULT_CONNECT_TIMEOUT_MILLIS;
    protected long requestTimeout = RpcClientConfigurationConstants.DEFAULT_REQUEST_TIMEOUT_MILLIS;

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public abstract void append(Event var1) throws EventDeliveryException;

    @Override
    public abstract void appendBatch(List<Event> var1) throws EventDeliveryException;

    @Override
    public abstract boolean isActive();

    @Override
    public abstract void close() throws FlumeException;

    protected abstract void configure(Properties var1) throws FlumeException;

    public static int parseBatchSize(Properties properties) {
        String strBatchSize = properties.getProperty("batch-size");
        logger.debug("Batch size string = " + strBatchSize);
        int batchSize = RpcClientConfigurationConstants.DEFAULT_BATCH_SIZE;
        if (strBatchSize != null && !strBatchSize.isEmpty()) {
            try {
                int parsedBatch = Integer.parseInt(strBatchSize);
                if (parsedBatch < 1) {
                    logger.warn("Invalid value for batchSize: {}; Using default value.", (Object)parsedBatch);
                } else {
                    batchSize = parsedBatch;
                }
            }
            catch (NumberFormatException e) {
                logger.warn("Batchsize is not valid for RpcClient: " + strBatchSize + ". Default value assigned.", (Throwable)e);
            }
        }
        return batchSize;
    }
}

