/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.user;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.InlongUserRoleEntity;
import org.apache.inlong.manager.dao.mapper.InlongUserRoleEntityMapper;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.user.InlongRoleInfo;
import org.apache.inlong.manager.pojo.user.InlongRolePageRequest;
import org.apache.inlong.manager.pojo.user.InlongRoleRequest;
import org.apache.inlong.manager.service.user.InlongRoleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InlongRoleServiceImpl
implements InlongRoleService {
    private static final Logger log = LoggerFactory.getLogger(InlongRoleServiceImpl.class);
    @Autowired
    private InlongUserRoleEntityMapper inlongUserMapper;

    @Override
    public PageResult<InlongRoleInfo> listByCondition(InlongRolePageRequest request) {
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        Page entityPage = this.inlongUserMapper.selectByCondition(request);
        return PageResult.fromPage((Page)entityPage).map(entity -> (InlongRoleInfo)CommonBeanUtils.copyProperties((Object)entity, InlongRoleInfo::new));
    }

    @Override
    public int save(InlongRoleRequest request, String operator) {
        String username = request.getUsername();
        Preconditions.expectNotBlank((String)username, (String)"Failed to save inlong user role, user should not be blank");
        Preconditions.expectNotBlank((String)request.getRoleCode(), (String)"Failed to save inlong user role, role code should not be blank");
        InlongUserRoleEntity entity = (InlongUserRoleEntity)CommonBeanUtils.copyProperties((Object)request, InlongUserRoleEntity::new);
        entity.setCreator(operator);
        entity.setModifier(operator);
        this.inlongUserMapper.insert(entity);
        return entity.getId();
    }

    @Override
    public boolean update(InlongRoleRequest request, String operator) {
        InlongUserRoleEntity exist = this.inlongUserMapper.selectById(request.getId());
        Preconditions.expectNotNull((Object)exist, (ErrorCodeEnum)ErrorCodeEnum.RECORD_NOT_FOUND, (String)String.format("inlong user role record not found by id=%s", request.getId()));
        InlongUserRoleEntity entity = (InlongUserRoleEntity)CommonBeanUtils.copyProperties((Object)request, InlongUserRoleEntity::new);
        entity.setModifier(operator);
        int rowCount = this.inlongUserMapper.updateById(entity);
        if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED, String.format("failure to update inlong user role with id=%d, request version=%d, updated row=%d", request.getId(), request.getVersion(), rowCount));
        }
        return true;
    }

    @Override
    public InlongRoleInfo get(int id) {
        InlongUserRoleEntity entity = this.inlongUserMapper.selectById(Integer.valueOf(id));
        if (entity == null) {
            log.debug("not found valid inlong role by id={}", (Object)id);
            return null;
        }
        return (InlongRoleInfo)CommonBeanUtils.copyProperties((Object)entity, InlongRoleInfo::new);
    }

    @Override
    public InlongRoleInfo getByUsername(String username) {
        InlongUserRoleEntity entity = this.inlongUserMapper.selectByUsername(username);
        if (entity == null) {
            log.debug("not found valid inlong role by name={}", (Object)username);
            return null;
        }
        return (InlongRoleInfo)CommonBeanUtils.copyProperties((Object)entity, InlongRoleInfo::new);
    }
}

