/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.ck;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.pojo.sink.ck.ClickHouseFieldInfo;
import org.apache.inlong.manager.pojo.sink.ck.ClickHouseTableInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClickHouseSqlBuilder {
    private static final int FIRST_COLUMN_INDEX = 0;
    private static final Logger LOGGER = LoggerFactory.getLogger(ClickHouseSqlBuilder.class);

    public static String buildCreateDbSql(String dbName) {
        String sql = "CREATE DATABASE IF NOT EXISTS " + dbName;
        LOGGER.info("create db sql: {}", (Object)sql);
        return sql;
    }

    public static String buildCreateTableSql(ClickHouseTableInfo table) {
        StringBuilder sql = new StringBuilder();
        String dbTableName = table.getDbName() + "." + table.getTableName();
        sql.append("CREATE TABLE ").append(dbTableName);
        if (StringUtils.isNotBlank((CharSequence)table.getCluster())) {
            sql.append(" ON CLUSTER ").append(table.getCluster());
        }
        if (table.getTtl() != null && StringUtils.isNotBlank((CharSequence)table.getTtlUnit())) {
            ClickHouseFieldInfo clickHouseFieldInfo = new ClickHouseFieldInfo();
            clickHouseFieldInfo.setFieldName("inlong_ttl_date_time");
            clickHouseFieldInfo.setFieldType("DateTime");
            clickHouseFieldInfo.setFieldComment("inlong ttl date time");
            clickHouseFieldInfo.setDefaultType("DEFAULT");
            clickHouseFieldInfo.setDefaultExpr("now()");
            table.getFieldInfoList().add(clickHouseFieldInfo);
        }
        sql.append(ClickHouseSqlBuilder.buildCreateColumnsSql(table.getFieldInfoList()));
        if (StringUtils.isNotBlank((CharSequence)table.getEngine()) && Objects.equals("ReplicatedMergeTree", table.getEngine())) {
            sql.append(" ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/{database}/{table}/data', '{replica}')");
        } else if (StringUtils.isNotBlank((CharSequence)table.getEngine())) {
            sql.append(" ENGINE = ").append(table.getEngine());
        } else {
            sql.append(" ENGINE = MergeTree()");
        }
        if (StringUtils.isNotEmpty((CharSequence)table.getOrderBy())) {
            sql.append(" ORDER BY ").append(table.getOrderBy());
        } else if (StringUtils.isEmpty((CharSequence)table.getEngine())) {
            sql.append(" ORDER BY ").append(((ClickHouseFieldInfo)table.getFieldInfoList().get(0)).getFieldName());
        }
        if (table.getTtl() != null && StringUtils.isNotBlank((CharSequence)table.getTtlUnit())) {
            sql.append(" TTL ").append("inlong_ttl_date_time").append(" + INTERVAL ").append(table.getTtl()).append(" ").append(table.getTtlUnit());
        }
        if (StringUtils.isNotEmpty((CharSequence)table.getPartitionBy())) {
            sql.append(" PARTITION BY ").append(table.getPartitionBy());
        }
        if (StringUtils.isNotEmpty((CharSequence)table.getPrimaryKey())) {
            sql.append(" PRIMARY KEY ").append(table.getPrimaryKey());
        }
        if (StringUtils.isNotEmpty((CharSequence)table.getTableDesc())) {
            sql.append(" COMMENT '").append(table.getTableDesc()).append("'");
        }
        LOGGER.info("create table sql: {}", (Object)sql);
        return sql.toString();
    }

    public static List<String> buildAddColumnsSql(String dbName, String tableName, List<ClickHouseFieldInfo> columnList) {
        String dbTableName = dbName + "." + tableName;
        List<String> columnInfoList = ClickHouseSqlBuilder.getColumnsInfo(columnList);
        ArrayList<String> resultList = new ArrayList<String>();
        for (String columnInfo : columnInfoList) {
            StringBuilder sql = new StringBuilder().append("ALTER TABLE ").append(dbTableName).append(" ADD COLUMN ").append(columnInfo);
            resultList.add(sql.toString());
        }
        return resultList;
    }

    private static String buildCreateColumnsSql(List<ClickHouseFieldInfo> columns) {
        List<String> columnList = ClickHouseSqlBuilder.getColumnsInfo(columns);
        StringBuilder result = new StringBuilder().append(" (").append(StringUtils.join(columnList, (String)",")).append(") ");
        return result.toString();
    }

    private static List<String> getColumnsInfo(List<ClickHouseFieldInfo> columns) {
        ArrayList<String> columnList = new ArrayList<String>();
        for (ClickHouseFieldInfo columnInfo : columns) {
            StringBuilder columnStr = new StringBuilder().append(columnInfo.getFieldName()).append(" ").append(columnInfo.getFieldType());
            if (StringUtils.isNotEmpty((CharSequence)columnInfo.getDefaultType())) {
                columnStr.append(" ").append(columnInfo.getDefaultType()).append(" ").append(columnInfo.getDefaultExpr());
            }
            if (StringUtils.isNotEmpty((CharSequence)columnInfo.getCompressionCode())) {
                columnStr.append(" CODEC(").append(columnInfo.getCompressionCode()).append(")");
            }
            if (StringUtils.isNotEmpty((CharSequence)columnInfo.getTtlExpr())) {
                columnStr.append(" TTL ").append(columnInfo.getTtlExpr());
            }
            if (StringUtils.isNotEmpty((CharSequence)columnInfo.getFieldComment())) {
                columnStr.append(" COMMENT '").append(columnInfo.getFieldComment()).append("'");
            }
            columnList.add(columnStr.toString());
        }
        return columnList;
    }

    public static String buildDescTableSql(String dbName, String tableName) {
        StringBuilder sql = new StringBuilder();
        String fullTableName = dbName + "." + tableName;
        sql.append("DESC ").append(fullTableName);
        LOGGER.info("desc table sql={}", (Object)sql);
        return sql.toString();
    }
}

