/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.listener.consume;

import com.alibaba.druid.util.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.TaskEvent;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.pojo.consume.InlongConsumeInfo;
import org.apache.inlong.manager.pojo.workflow.form.process.ApplyConsumeProcessForm;
import org.apache.inlong.manager.pojo.workflow.form.task.ConsumeApproveForm;
import org.apache.inlong.manager.service.consume.InlongConsumeService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.TaskEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OperateConsumeTaskListener
implements TaskEventListener {
    private static final Logger log = LoggerFactory.getLogger(OperateConsumeTaskListener.class);
    @Autowired
    private InlongConsumeService consumeService;

    public TaskEvent event() {
        return TaskEvent.APPROVE;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        ApplyConsumeProcessForm consumeForm = (ApplyConsumeProcessForm)context.getProcessForm();
        ConsumeApproveForm approveForm = (ConsumeApproveForm)context.getActionContext().getForm();
        InlongConsumeInfo consumeInfo = consumeForm.getConsumeInfo();
        if (StringUtils.equals((String)approveForm.getConsumerGroup(), (String)consumeInfo.getConsumerGroup())) {
            return ListenerResult.success((String)"Consumer group has not been modified");
        }
        boolean exist = this.consumeService.consumerGroupExists(approveForm.getConsumerGroup(), consumeInfo.getId());
        if (exist) {
            log.error("consumer group {} already exist", (Object)approveForm.getConsumerGroup());
            throw new BusinessException(ErrorCodeEnum.CONSUMER_GROUP_DUPLICATED);
        }
        return ListenerResult.success((String)String.format("Consumer group %s change to %s", consumeInfo.getConsumerGroup(), approveForm.getConsumerGroup()));
    }
}

