/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.consume;

import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.ConsumeStatus;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.InlongConsumeEntity;
import org.apache.inlong.manager.dao.mapper.InlongConsumeEntityMapper;
import org.apache.inlong.manager.pojo.consume.InlongConsumeRequest;
import org.apache.inlong.manager.service.consume.InlongConsumeOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractConsumeOperator
implements InlongConsumeOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractConsumeOperator.class);
    @Autowired
    private InlongConsumeEntityMapper consumeMapper;

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Integer saveOpt(InlongConsumeRequest request, String operator) {
        this.checkTopicInfo(request);
        InlongConsumeEntity entity = (InlongConsumeEntity)CommonBeanUtils.copyProperties((Object)request, InlongConsumeEntity::new);
        this.setTargetEntity(request, entity);
        entity.setStatus(ConsumeStatus.TO_BE_SUBMIT.getCode());
        entity.setCreator(operator);
        entity.setModifier(operator);
        this.consumeMapper.insert(entity);
        return entity.getId();
    }

    protected abstract void setTargetEntity(InlongConsumeRequest var1, InlongConsumeEntity var2);

    @Override
    @Transactional(rollbackFor={Throwable.class}, isolation=Isolation.REPEATABLE_READ)
    public void updateOpt(InlongConsumeRequest request, String operator) {
        if (StringUtils.isNotBlank((CharSequence)request.getTopic())) {
            this.checkTopicInfo(request);
        }
        InlongConsumeEntity entity = this.consumeMapper.selectById(request.getId());
        this.setTargetEntity(request, entity);
        entity.setModifier(operator);
        int rowCount = this.consumeMapper.updateByIdSelective(entity);
        if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
            LOGGER.error("inlong consume has already updated with id={}, expire version={}", (Object)request.getId(), (Object)request.getVersion());
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
    }
}

