/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.condition;

import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TransformFunction(type="condition", names={"ifnull", "if_null"}, parameter="(Expr expr1,Expr expr2)", descriptions={"- Return 'expr1' if 'expr1' returns not NULL;", "- Return 'expr2' otherwise."}, examples={"ifnull(null, 3) = 3", "ifnull(6,'YES') = 6"})
public class IfNullFunction
implements ValueParser {
    private static final Logger log = LoggerFactory.getLogger(IfNullFunction.class);
    private final ValueParser firstExprParser;
    private final ValueParser secondExprParser;

    public IfNullFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.firstExprParser = OperatorTools.buildParser((Expression)expressions.get(0));
        this.secondExprParser = OperatorTools.buildParser((Expression)expressions.get(1));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        try {
            Object firstExprObj = this.firstExprParser.parse(sourceData, rowIndex, context);
            if (firstExprObj == null) {
                return this.parseSecondExpr(sourceData, rowIndex, context);
            }
            return firstExprObj;
        }
        catch (Exception e) {
            log.error("Value parsing failed", (Throwable)e);
            return this.parseSecondExpr(sourceData, rowIndex, context);
        }
    }

    private Object parseSecondExpr(SourceData sourceData, int rowIndex, Context context) {
        try {
            return this.secondExprParser.parse(sourceData, rowIndex, context);
        }
        catch (Exception e) {
            log.error("Value parsing failed", (Throwable)e);
            return null;
        }
    }
}

