/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.arithmetic;

import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="arithmetic", names={"cbrt"}, parameter="(Numeric numeric)", descriptions={"- Return NULL if 'numeric' is NULL;", "- Return cube root."}, examples={"cbrt(5) = 1.7099759466766968", "cbrt(27) = 3.0"})
public class CbrtFunction
implements ValueParser {
    private ValueParser numParser;

    public CbrtFunction(Function expr) {
        this.numParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object numObj = this.numParser.parse(sourceData, rowIndex, context);
        if (numObj == null) {
            return null;
        }
        double num = OperatorTools.parseBigDecimal(numObj).doubleValue();
        return Math.pow(num, 0.3333333333333333);
    }
}

