/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.arithmetic;

import java.math.BigDecimal;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="arithmetic", names={"atan2d"}, parameter="(Numeric numericx, Numeric numericy)", descriptions={"- Return \"\" if 'numericx' or 'numericy' is NULL;", "- Return inverse tangent of 'numericy'/'numericx', result in degrees."}, examples={"atan2d(1, 1) = 45.0", "atan2d(1, 0) = 90.0", "atan2d(0, -1) = 180.0"})
public class Atan2dFunction
implements ValueParser {
    private ValueParser xParser;
    private ValueParser yParser;

    public Atan2dFunction(Function expr) {
        this.xParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
        this.yParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(1));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object xObj = this.xParser.parse(sourceData, rowIndex, context);
        Object yObj = this.yParser.parse(sourceData, rowIndex, context);
        if (xObj == null || yObj == null) {
            return null;
        }
        BigDecimal xValue = OperatorTools.parseBigDecimal(xObj);
        BigDecimal yValue = OperatorTools.parseBigDecimal(yObj);
        return Math.toDegrees(Math.atan2(xValue.doubleValue(), yValue.doubleValue()));
    }
}

