/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.pipeline.spi.Partition;
import io.debezium.util.Collect;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SqlServerPartition
implements Partition {
    private static final String SERVER_PARTITION_KEY = "server";
    private static final String DATABASE_PARTITION_KEY = "database";
    private final String serverName;
    private final String databaseName;
    private final Map<String, String> sourcePartition;
    private final int hashCode;

    public SqlServerPartition(String serverName, String databaseName, boolean multiPartitionMode) {
        this.serverName = serverName;
        this.databaseName = databaseName;
        this.sourcePartition = Collect.hashMapOf((Object)SERVER_PARTITION_KEY, (Object)serverName);
        if (multiPartitionMode) {
            this.sourcePartition.put(DATABASE_PARTITION_KEY, databaseName);
        }
        this.hashCode = Objects.hash(serverName, databaseName);
    }

    public Map<String, String> getSourcePartition() {
        return this.sourcePartition;
    }

    String getDatabaseName() {
        return this.databaseName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SqlServerPartition other = (SqlServerPartition)obj;
        return Objects.equals(this.serverName, other.serverName) && Objects.equals(this.databaseName, other.databaseName);
    }

    public int hashCode() {
        return this.hashCode;
    }

    static class Provider
    implements Partition.Provider<SqlServerPartition> {
        private final SqlServerConnectorConfig connectorConfig;

        Provider(SqlServerConnectorConfig connectorConfig) {
            this.connectorConfig = connectorConfig;
        }

        public Set<SqlServerPartition> getPartitions() {
            return Collections.singleton(new SqlServerPartition(this.connectorConfig.getLogicalName(), this.connectorConfig.getDatabaseName(), this.connectorConfig.isMultiPartitionModeEnabled()));
        }
    }
}

