/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen;

import java.io.Serializable;
import org.apache.flink.table.planner.codegen.CodeGenUtils$;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.GenerateUtils$;
import org.apache.flink.table.planner.codegen.GeneratedExpression;
import org.apache.flink.table.planner.codegen.Indenter$;
import org.apache.flink.table.runtime.generated.GeneratedHashFunction;
import org.apache.flink.table.runtime.generated.HashFunction;
import org.apache.flink.table.types.logical.LogicalType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class HashCodeGenerator$ {
    public static HashCodeGenerator$ MODULE$;
    private final int[] HASH_SALT;

    static {
        new HashCodeGenerator$();
    }

    public int[] HASH_SALT() {
        return this.HASH_SALT;
    }

    public GeneratedHashFunction generateRowHash(CodeGeneratorContext ctx, LogicalType input, String name, int[] hashFields) {
        String className = CodeGenUtils$.MODULE$.newName(name);
        Class<HashFunction> baseClass = HashFunction.class;
        String inputTerm = CodeGenUtils$.MODULE$.DEFAULT_INPUT1_TERM();
        GeneratedExpression[] accessExprs = (GeneratedExpression[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(hashFields)).map((Function1 & Serializable & scala.Serializable)idx -> GenerateUtils$.MODULE$.generateFieldAccess(ctx, input, inputTerm, BoxesRunTime.unboxToInt((Object)idx)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(GeneratedExpression.class)));
        Tuple2<String, String> tuple2 = this.generateCodeBody(ctx, (Seq<GeneratedExpression>)Predef$.MODULE$.wrapRefArray((Object[])accessExprs));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String hashBody = (String)tuple2._1();
        String resultTerm = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)hashBody, (Object)resultTerm);
        Tuple2 tuple23 = tuple22;
        String hashBody2 = (String)tuple23._1();
        String resultTerm2 = (String)tuple23._2();
        String code = new StringOps(Predef$.MODULE$.augmentString(Indenter$.MODULE$.toISC(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      public class ", " implements ", " {\n\n        ", "\n\n        public ", "(Object[] references) throws Exception {\n          ", "\n        }\n\n        @Override\n        public int hashCode(", " ", ") {\n          ", "\n          ", "\n          return ", ";\n        }\n\n        ", "\n      }\n    "}))).j((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{className, baseClass.getCanonicalName(), ctx.reuseMemberCode(), className, ctx.reuseInitCode(), CodeGenUtils$.MODULE$.ROW_DATA(), inputTerm, ctx.reuseLocalVariableCode(ctx.reuseLocalVariableCode$default$1()), hashBody2, resultTerm2, ctx.reuseInnerClassDefinitionCode()})))).stripMargin();
        return new GeneratedHashFunction(className, code, (Object[])ctx.references().toArray(ClassTag$.MODULE$.AnyRef()), ctx.tableConfig().getConfiguration());
    }

    private Tuple2<String, String> generateCodeBody(CodeGeneratorContext ctx, Seq<GeneratedExpression> accessExprs) {
        String hashIntTerm = CodeGenUtils$.MODULE$.newName("hashCode");
        IntRef i = IntRef.create((int)-1);
        String hashBodyCode = ((TraversableOnce)accessExprs.map((Function1 & Serializable & scala.Serializable)expr -> {
            ++i$1.elem;
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(110).append("\n             |").append(hashIntTerm).append(" *= ").append(MODULE$.HASH_SALT()[i$1.elem & 0x1F]).append(";\n             |").append(expr.code()).append("\n             |if (!").append(expr.nullTerm()).append(") {\n             | ").append(hashIntTerm).append(" += ").append(CodeGenUtils$.MODULE$.hashCodeForType(ctx, expr.resultType(), expr.resultTerm())).append(";\n             |}\n             |").toString())).stripMargin();
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
        return new Tuple2((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(31).append("\n         |int ").append(hashIntTerm).append(" = 0;\n         |").append(hashBodyCode).toString())).stripMargin(), (Object)hashIntTerm);
    }

    private HashCodeGenerator$() {
        MODULE$ = this;
        this.HASH_SALT = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{73, 79, 97, 113, 131, 197, 199, 311, 337, 373, 719, 733, 919, 971, 991, 1193, 1931, 3119, 3779, 7793, 7937, 9311, 9377, 11939, 19391, 19937, 37199, 39119, 71993, 91193, 93719, 93911}), ClassTag$.MODULE$.Int());
    }
}

