/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.flink.sql.parser.ddl.SqlAlterTable;
import org.apache.flink.sql.parser.ddl.SqlTableColumn;

public class SqlChangeColumn
extends SqlAlterTable {
    private final SqlIdentifier oldName;
    private final SqlTableColumn newColumn;
    private final SqlIdentifier after;
    private final boolean first;
    private final SqlNodeList properties;

    public SqlChangeColumn(SqlParserPos pos, SqlIdentifier tableName, SqlIdentifier oldName, SqlTableColumn newColumn, @Nullable SqlIdentifier after, boolean first, @Nullable SqlNodeList properties) {
        super(pos, tableName);
        if (after != null && first) {
            throw new IllegalArgumentException("FIRST and AFTER cannot be set at the same time");
        }
        this.oldName = oldName;
        this.newColumn = newColumn;
        this.after = after;
        this.first = first;
        this.properties = properties;
    }

    public SqlIdentifier getOldName() {
        return this.oldName;
    }

    public SqlTableColumn getNewColumn() {
        return this.newColumn;
    }

    public SqlIdentifier getAfter() {
        return this.after;
    }

    public boolean isFirst() {
        return this.first;
    }

    public SqlNodeList getProperties() {
        return this.properties;
    }

    @Override
    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.tableIdentifier, this.partitionSpec, this.oldName, this.newColumn, this.after);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        super.unparse(writer, leftPrec, rightPrec);
        writer.keyword("CHANGE COLUMN");
        this.oldName.unparse(writer, leftPrec, rightPrec);
        this.newColumn.unparse(writer, leftPrec, rightPrec);
        if (this.first) {
            writer.keyword("FIST");
        }
        if (this.after != null) {
            writer.keyword("AFTER");
            this.after.unparse(writer, leftPrec, rightPrec);
        }
    }
}

