/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.metrics.stats;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import org.apache.inlong.dataproxy.metrics.stats.AbsStatsDaemon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorStats
extends AbsStatsDaemon {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorStats.class);
    private final StatsUnit[] statsUnits = new StatsUnit[2];

    public MonitorStats(String name, long intervalMill, int maxCnt) {
        super(name, intervalMill, maxCnt);
        this.statsUnits[0] = new StatsUnit(name);
        this.statsUnits[1] = new StatsUnit(name);
    }

    public void incSumStats(String sumKey) {
        if (this.isStopped()) {
            return;
        }
        this.statsUnits[this.getWriteIndex()].incSumStats(sumKey);
    }

    public void incDetailStats(String detailKey) {
        if (this.isStopped()) {
            return;
        }
        this.statsUnits[this.getWriteIndex()].incDetailStats(detailKey);
    }

    @Override
    protected int loopProcess(long startTime) {
        return this.statsUnits[this.getReadIndex()].printAndResetStatsInfo();
    }

    @Override
    protected int exitProcess(long startTime) {
        int totalCnt = 0;
        if (!this.statsUnits[this.getReadIndex()].isEmpty()) {
            totalCnt += this.statsUnits[this.getReadIndex()].printAndResetStatsInfo();
        }
        if (!this.statsUnits[this.getWriteIndex()].isEmpty()) {
            totalCnt += this.statsUnits[this.getWriteIndex()].printAndResetStatsInfo();
        }
        return totalCnt;
    }

    private static class StatsUnit {
        private final String statsName;
        private final ConcurrentHashMap<String, LongAdder> sumMap = new ConcurrentHashMap();
        private final ConcurrentHashMap<String, LongAdder> detailsMap = new ConcurrentHashMap();

        public StatsUnit(String statsName) {
            this.statsName = statsName;
        }

        public boolean isEmpty() {
            return this.sumMap.isEmpty() && this.detailsMap.isEmpty();
        }

        public void incSumStats(String key) {
            LongAdder tmpItem;
            LongAdder statsItem = this.sumMap.get(key);
            if (statsItem == null && (statsItem = this.sumMap.putIfAbsent(key, tmpItem = new LongAdder())) == null) {
                statsItem = tmpItem;
            }
            statsItem.increment();
        }

        public void incDetailStats(String key) {
            LongAdder tmpItem;
            LongAdder statsItem = this.detailsMap.get(key);
            if (statsItem == null && (statsItem = this.detailsMap.putIfAbsent(key, tmpItem = new LongAdder())) == null) {
                statsItem = tmpItem;
            }
            statsItem.increment();
        }

        public int printAndResetStatsInfo() {
            int sumCnt = 0;
            for (Map.Entry<String, LongAdder> entry : this.sumMap.entrySet()) {
                if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
                LOGGER.info("{}.summary.{}={}", new Object[]{this.statsName, entry.getKey(), entry.getValue()});
                ++sumCnt;
            }
            for (Map.Entry<String, LongAdder> entry : this.detailsMap.entrySet()) {
                if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
                LOGGER.info("{}.detail.{}={}", new Object[]{this.statsName, entry.getKey(), entry.getValue()});
                ++sumCnt;
            }
            this.sumMap.clear();
            this.detailsMap.clear();
            return sumCnt;
        }
    }
}

