/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.tools.cli;

import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.inlong.tubemq.server.common.fielddef.CliArgDef;

public abstract class CliAbstractBase {
    protected final String commandName;
    protected Options options = new Options();
    protected CommandLineParser parser = new DefaultParser();
    private final HelpFormatter formatter = new HelpFormatter();

    public CliAbstractBase(String commandName) {
        this.commandName = commandName;
        this.addCommandOption(CliArgDef.HELP);
        this.addCommandOption(CliArgDef.VERSION);
        this.formatter.setWidth(500);
    }

    public void help() {
        this.formatter.printHelp(this.commandName, this.options);
        System.exit(0);
    }

    public void version() {
        System.out.println("TubeMQ 2.3.0");
        System.exit(0);
    }

    public void addCommandOption(CliArgDef cliArgDef) {
        Option option = new Option(cliArgDef.opt, cliArgDef.longOpt, cliArgDef.hasArg, cliArgDef.optDesc);
        if (cliArgDef.hasArg) {
            option.setArgName(cliArgDef.argDesc);
        }
        this.options.addOption(option);
    }

    protected abstract void initCommandOptions();

    public abstract boolean processParams(String[] var1) throws Exception;
}

