/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.web.simplemvc;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.inlong.tubemq.server.master.web.simplemvc.MultipartHttpServletRequest;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.MimeTypes;

public class WebFilter
implements Filter {
    private static boolean isMultipartFormData(HttpServletRequest req) {
        String contentType = req.getContentType();
        return contentType != null && MimeTypes.Type.MULTIPART_FORM_DATA.is(HttpFields.valueParameters((String)contentType, null));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req;
        if (request instanceof HttpServletRequest && WebFilter.isMultipartFormData(req = (HttpServletRequest)request)) {
            chain.doFilter((ServletRequest)new MultipartHttpServletRequest(req), response);
            return;
        }
        chain.doFilter(request, response);
    }
}

